/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.greengrass.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.greengrass.model.FunctionIsolationMode;
import com.amazonaws.services.greengrass.model.FunctionRunAsConfig;
import com.amazonaws.services.greengrass.model.transform.FunctionExecutionConfigMarshaller;
import java.io.Serializable;

public class FunctionExecutionConfig
implements Serializable,
Cloneable,
StructuredPojo {
    private String isolationMode;
    private FunctionRunAsConfig runAs;

    public void setIsolationMode(String isolationMode) {
        this.isolationMode = isolationMode;
    }

    public String getIsolationMode() {
        return this.isolationMode;
    }

    public FunctionExecutionConfig withIsolationMode(String isolationMode) {
        this.setIsolationMode(isolationMode);
        return this;
    }

    public FunctionExecutionConfig withIsolationMode(FunctionIsolationMode isolationMode) {
        this.isolationMode = isolationMode.toString();
        return this;
    }

    public void setRunAs(FunctionRunAsConfig runAs) {
        this.runAs = runAs;
    }

    public FunctionRunAsConfig getRunAs() {
        return this.runAs;
    }

    public FunctionExecutionConfig withRunAs(FunctionRunAsConfig runAs) {
        this.setRunAs(runAs);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getIsolationMode() != null) {
            sb.append("IsolationMode: ").append(this.getIsolationMode()).append(",");
        }
        if (this.getRunAs() != null) {
            sb.append("RunAs: ").append(this.getRunAs());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FunctionExecutionConfig)) {
            return false;
        }
        FunctionExecutionConfig other = (FunctionExecutionConfig)obj;
        if (other.getIsolationMode() == null ^ this.getIsolationMode() == null) {
            return false;
        }
        if (other.getIsolationMode() != null && !other.getIsolationMode().equals(this.getIsolationMode())) {
            return false;
        }
        if (other.getRunAs() == null ^ this.getRunAs() == null) {
            return false;
        }
        return other.getRunAs() == null || other.getRunAs().equals(this.getRunAs());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getIsolationMode() == null ? 0 : this.getIsolationMode().hashCode());
        hashCode = 31 * hashCode + (this.getRunAs() == null ? 0 : this.getRunAs().hashCode());
        return hashCode;
    }

    public FunctionExecutionConfig clone() {
        try {
            return (FunctionExecutionConfig)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        FunctionExecutionConfigMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

