/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.gluedatabrew.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.gluedatabrew.model.AnalyticsMode;
import com.amazonaws.services.gluedatabrew.model.transform.ViewFrameMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ViewFrame
implements Serializable,
Cloneable,
StructuredPojo {
    private Integer startColumnIndex;
    private Integer columnRange;
    private List<String> hiddenColumns;
    private Integer startRowIndex;
    private Integer rowRange;
    private String analytics;

    public void setStartColumnIndex(Integer startColumnIndex) {
        this.startColumnIndex = startColumnIndex;
    }

    public Integer getStartColumnIndex() {
        return this.startColumnIndex;
    }

    public ViewFrame withStartColumnIndex(Integer startColumnIndex) {
        this.setStartColumnIndex(startColumnIndex);
        return this;
    }

    public void setColumnRange(Integer columnRange) {
        this.columnRange = columnRange;
    }

    public Integer getColumnRange() {
        return this.columnRange;
    }

    public ViewFrame withColumnRange(Integer columnRange) {
        this.setColumnRange(columnRange);
        return this;
    }

    public List<String> getHiddenColumns() {
        return this.hiddenColumns;
    }

    public void setHiddenColumns(Collection<String> hiddenColumns) {
        if (hiddenColumns == null) {
            this.hiddenColumns = null;
            return;
        }
        this.hiddenColumns = new ArrayList<String>(hiddenColumns);
    }

    public ViewFrame withHiddenColumns(String ... hiddenColumns) {
        if (this.hiddenColumns == null) {
            this.setHiddenColumns(new ArrayList<String>(hiddenColumns.length));
        }
        for (String ele : hiddenColumns) {
            this.hiddenColumns.add(ele);
        }
        return this;
    }

    public ViewFrame withHiddenColumns(Collection<String> hiddenColumns) {
        this.setHiddenColumns(hiddenColumns);
        return this;
    }

    public void setStartRowIndex(Integer startRowIndex) {
        this.startRowIndex = startRowIndex;
    }

    public Integer getStartRowIndex() {
        return this.startRowIndex;
    }

    public ViewFrame withStartRowIndex(Integer startRowIndex) {
        this.setStartRowIndex(startRowIndex);
        return this;
    }

    public void setRowRange(Integer rowRange) {
        this.rowRange = rowRange;
    }

    public Integer getRowRange() {
        return this.rowRange;
    }

    public ViewFrame withRowRange(Integer rowRange) {
        this.setRowRange(rowRange);
        return this;
    }

    public void setAnalytics(String analytics) {
        this.analytics = analytics;
    }

    public String getAnalytics() {
        return this.analytics;
    }

    public ViewFrame withAnalytics(String analytics) {
        this.setAnalytics(analytics);
        return this;
    }

    public ViewFrame withAnalytics(AnalyticsMode analytics) {
        this.analytics = analytics.toString();
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getStartColumnIndex() != null) {
            sb.append("StartColumnIndex: ").append(this.getStartColumnIndex()).append(",");
        }
        if (this.getColumnRange() != null) {
            sb.append("ColumnRange: ").append(this.getColumnRange()).append(",");
        }
        if (this.getHiddenColumns() != null) {
            sb.append("HiddenColumns: ").append(this.getHiddenColumns()).append(",");
        }
        if (this.getStartRowIndex() != null) {
            sb.append("StartRowIndex: ").append(this.getStartRowIndex()).append(",");
        }
        if (this.getRowRange() != null) {
            sb.append("RowRange: ").append(this.getRowRange()).append(",");
        }
        if (this.getAnalytics() != null) {
            sb.append("Analytics: ").append(this.getAnalytics());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ViewFrame)) {
            return false;
        }
        ViewFrame other = (ViewFrame)obj;
        if (other.getStartColumnIndex() == null ^ this.getStartColumnIndex() == null) {
            return false;
        }
        if (other.getStartColumnIndex() != null && !other.getStartColumnIndex().equals(this.getStartColumnIndex())) {
            return false;
        }
        if (other.getColumnRange() == null ^ this.getColumnRange() == null) {
            return false;
        }
        if (other.getColumnRange() != null && !other.getColumnRange().equals(this.getColumnRange())) {
            return false;
        }
        if (other.getHiddenColumns() == null ^ this.getHiddenColumns() == null) {
            return false;
        }
        if (other.getHiddenColumns() != null && !other.getHiddenColumns().equals(this.getHiddenColumns())) {
            return false;
        }
        if (other.getStartRowIndex() == null ^ this.getStartRowIndex() == null) {
            return false;
        }
        if (other.getStartRowIndex() != null && !other.getStartRowIndex().equals(this.getStartRowIndex())) {
            return false;
        }
        if (other.getRowRange() == null ^ this.getRowRange() == null) {
            return false;
        }
        if (other.getRowRange() != null && !other.getRowRange().equals(this.getRowRange())) {
            return false;
        }
        if (other.getAnalytics() == null ^ this.getAnalytics() == null) {
            return false;
        }
        return other.getAnalytics() == null || other.getAnalytics().equals(this.getAnalytics());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getStartColumnIndex() == null ? 0 : this.getStartColumnIndex().hashCode());
        hashCode = 31 * hashCode + (this.getColumnRange() == null ? 0 : this.getColumnRange().hashCode());
        hashCode = 31 * hashCode + (this.getHiddenColumns() == null ? 0 : this.getHiddenColumns().hashCode());
        hashCode = 31 * hashCode + (this.getStartRowIndex() == null ? 0 : this.getStartRowIndex().hashCode());
        hashCode = 31 * hashCode + (this.getRowRange() == null ? 0 : this.getRowRange().hashCode());
        hashCode = 31 * hashCode + (this.getAnalytics() == null ? 0 : this.getAnalytics().hashCode());
        return hashCode;
    }

    public ViewFrame clone() {
        try {
            return (ViewFrame)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ViewFrameMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

