/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.gluedatabrew.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.gluedatabrew.model.StatisticsConfiguration;
import java.util.List;

@SdkInternalApi
public class StatisticsConfigurationMarshaller {
    private static final MarshallingInfo<List> INCLUDEDSTATISTICS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("IncludedStatistics").build();
    private static final MarshallingInfo<List> OVERRIDES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Overrides").build();
    private static final StatisticsConfigurationMarshaller instance = new StatisticsConfigurationMarshaller();

    public static StatisticsConfigurationMarshaller getInstance() {
        return instance;
    }

    public void marshall(StatisticsConfiguration statisticsConfiguration, ProtocolMarshaller protocolMarshaller) {
        if (statisticsConfiguration == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(statisticsConfiguration.getIncludedStatistics(), INCLUDEDSTATISTICS_BINDING);
            protocolMarshaller.marshall(statisticsConfiguration.getOverrides(), OVERRIDES_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

