/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.gluedatabrew.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.gluedatabrew.model.ColumnSelector;
import com.amazonaws.services.gluedatabrew.model.ColumnStatisticsConfiguration;
import com.amazonaws.services.gluedatabrew.model.EntityDetectorConfiguration;
import com.amazonaws.services.gluedatabrew.model.StatisticsConfiguration;
import com.amazonaws.services.gluedatabrew.model.transform.ProfileConfigurationMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ProfileConfiguration
implements Serializable,
Cloneable,
StructuredPojo {
    private StatisticsConfiguration datasetStatisticsConfiguration;
    private List<ColumnSelector> profileColumns;
    private List<ColumnStatisticsConfiguration> columnStatisticsConfigurations;
    private EntityDetectorConfiguration entityDetectorConfiguration;

    public void setDatasetStatisticsConfiguration(StatisticsConfiguration datasetStatisticsConfiguration) {
        this.datasetStatisticsConfiguration = datasetStatisticsConfiguration;
    }

    public StatisticsConfiguration getDatasetStatisticsConfiguration() {
        return this.datasetStatisticsConfiguration;
    }

    public ProfileConfiguration withDatasetStatisticsConfiguration(StatisticsConfiguration datasetStatisticsConfiguration) {
        this.setDatasetStatisticsConfiguration(datasetStatisticsConfiguration);
        return this;
    }

    public List<ColumnSelector> getProfileColumns() {
        return this.profileColumns;
    }

    public void setProfileColumns(Collection<ColumnSelector> profileColumns) {
        if (profileColumns == null) {
            this.profileColumns = null;
            return;
        }
        this.profileColumns = new ArrayList<ColumnSelector>(profileColumns);
    }

    public ProfileConfiguration withProfileColumns(ColumnSelector ... profileColumns) {
        if (this.profileColumns == null) {
            this.setProfileColumns(new ArrayList<ColumnSelector>(profileColumns.length));
        }
        for (ColumnSelector ele : profileColumns) {
            this.profileColumns.add(ele);
        }
        return this;
    }

    public ProfileConfiguration withProfileColumns(Collection<ColumnSelector> profileColumns) {
        this.setProfileColumns(profileColumns);
        return this;
    }

    public List<ColumnStatisticsConfiguration> getColumnStatisticsConfigurations() {
        return this.columnStatisticsConfigurations;
    }

    public void setColumnStatisticsConfigurations(Collection<ColumnStatisticsConfiguration> columnStatisticsConfigurations) {
        if (columnStatisticsConfigurations == null) {
            this.columnStatisticsConfigurations = null;
            return;
        }
        this.columnStatisticsConfigurations = new ArrayList<ColumnStatisticsConfiguration>(columnStatisticsConfigurations);
    }

    public ProfileConfiguration withColumnStatisticsConfigurations(ColumnStatisticsConfiguration ... columnStatisticsConfigurations) {
        if (this.columnStatisticsConfigurations == null) {
            this.setColumnStatisticsConfigurations(new ArrayList<ColumnStatisticsConfiguration>(columnStatisticsConfigurations.length));
        }
        for (ColumnStatisticsConfiguration ele : columnStatisticsConfigurations) {
            this.columnStatisticsConfigurations.add(ele);
        }
        return this;
    }

    public ProfileConfiguration withColumnStatisticsConfigurations(Collection<ColumnStatisticsConfiguration> columnStatisticsConfigurations) {
        this.setColumnStatisticsConfigurations(columnStatisticsConfigurations);
        return this;
    }

    public void setEntityDetectorConfiguration(EntityDetectorConfiguration entityDetectorConfiguration) {
        this.entityDetectorConfiguration = entityDetectorConfiguration;
    }

    public EntityDetectorConfiguration getEntityDetectorConfiguration() {
        return this.entityDetectorConfiguration;
    }

    public ProfileConfiguration withEntityDetectorConfiguration(EntityDetectorConfiguration entityDetectorConfiguration) {
        this.setEntityDetectorConfiguration(entityDetectorConfiguration);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getDatasetStatisticsConfiguration() != null) {
            sb.append("DatasetStatisticsConfiguration: ").append(this.getDatasetStatisticsConfiguration()).append(",");
        }
        if (this.getProfileColumns() != null) {
            sb.append("ProfileColumns: ").append(this.getProfileColumns()).append(",");
        }
        if (this.getColumnStatisticsConfigurations() != null) {
            sb.append("ColumnStatisticsConfigurations: ").append(this.getColumnStatisticsConfigurations()).append(",");
        }
        if (this.getEntityDetectorConfiguration() != null) {
            sb.append("EntityDetectorConfiguration: ").append(this.getEntityDetectorConfiguration());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ProfileConfiguration)) {
            return false;
        }
        ProfileConfiguration other = (ProfileConfiguration)obj;
        if (other.getDatasetStatisticsConfiguration() == null ^ this.getDatasetStatisticsConfiguration() == null) {
            return false;
        }
        if (other.getDatasetStatisticsConfiguration() != null && !other.getDatasetStatisticsConfiguration().equals(this.getDatasetStatisticsConfiguration())) {
            return false;
        }
        if (other.getProfileColumns() == null ^ this.getProfileColumns() == null) {
            return false;
        }
        if (other.getProfileColumns() != null && !other.getProfileColumns().equals(this.getProfileColumns())) {
            return false;
        }
        if (other.getColumnStatisticsConfigurations() == null ^ this.getColumnStatisticsConfigurations() == null) {
            return false;
        }
        if (other.getColumnStatisticsConfigurations() != null && !other.getColumnStatisticsConfigurations().equals(this.getColumnStatisticsConfigurations())) {
            return false;
        }
        if (other.getEntityDetectorConfiguration() == null ^ this.getEntityDetectorConfiguration() == null) {
            return false;
        }
        return other.getEntityDetectorConfiguration() == null || other.getEntityDetectorConfiguration().equals(this.getEntityDetectorConfiguration());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getDatasetStatisticsConfiguration() == null ? 0 : this.getDatasetStatisticsConfiguration().hashCode());
        hashCode = 31 * hashCode + (this.getProfileColumns() == null ? 0 : this.getProfileColumns().hashCode());
        hashCode = 31 * hashCode + (this.getColumnStatisticsConfigurations() == null ? 0 : this.getColumnStatisticsConfigurations().hashCode());
        hashCode = 31 * hashCode + (this.getEntityDetectorConfiguration() == null ? 0 : this.getEntityDetectorConfiguration().hashCode());
        return hashCode;
    }

    public ProfileConfiguration clone() {
        try {
            return (ProfileConfiguration)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ProfileConfigurationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

