/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.glue.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.glue.model.Recipe;
import java.util.List;

@SdkInternalApi
public class RecipeMarshaller {
    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Name").build();
    private static final MarshallingInfo<List> INPUTS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Inputs").build();
    private static final MarshallingInfo<StructuredPojo> RECIPEREFERENCE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RecipeReference").build();
    private static final MarshallingInfo<List> RECIPESTEPS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RecipeSteps").build();
    private static final RecipeMarshaller instance = new RecipeMarshaller();

    public static RecipeMarshaller getInstance() {
        return instance;
    }

    public void marshall(Recipe recipe, ProtocolMarshaller protocolMarshaller) {
        if (recipe == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)recipe.getName(), NAME_BINDING);
            protocolMarshaller.marshall(recipe.getInputs(), INPUTS_BINDING);
            protocolMarshaller.marshall((Object)recipe.getRecipeReference(), RECIPEREFERENCE_BINDING);
            protocolMarshaller.marshall(recipe.getRecipeSteps(), RECIPESTEPS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

