/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.globalaccelerator.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.globalaccelerator.model.Resource;
import com.amazonaws.services.globalaccelerator.model.Tag;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class CreateCrossAccountAttachmentRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String name;
    private List<String> principals;
    private List<Resource> resources;
    private String idempotencyToken;
    private List<Tag> tags;

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public CreateCrossAccountAttachmentRequest withName(String name) {
        this.setName(name);
        return this;
    }

    public List<String> getPrincipals() {
        return this.principals;
    }

    public void setPrincipals(Collection<String> principals) {
        if (principals == null) {
            this.principals = null;
            return;
        }
        this.principals = new ArrayList<String>(principals);
    }

    public CreateCrossAccountAttachmentRequest withPrincipals(String ... principals) {
        if (this.principals == null) {
            this.setPrincipals(new ArrayList<String>(principals.length));
        }
        for (String ele : principals) {
            this.principals.add(ele);
        }
        return this;
    }

    public CreateCrossAccountAttachmentRequest withPrincipals(Collection<String> principals) {
        this.setPrincipals(principals);
        return this;
    }

    public List<Resource> getResources() {
        return this.resources;
    }

    public void setResources(Collection<Resource> resources) {
        if (resources == null) {
            this.resources = null;
            return;
        }
        this.resources = new ArrayList<Resource>(resources);
    }

    public CreateCrossAccountAttachmentRequest withResources(Resource ... resources) {
        if (this.resources == null) {
            this.setResources(new ArrayList<Resource>(resources.length));
        }
        for (Resource ele : resources) {
            this.resources.add(ele);
        }
        return this;
    }

    public CreateCrossAccountAttachmentRequest withResources(Collection<Resource> resources) {
        this.setResources(resources);
        return this;
    }

    public void setIdempotencyToken(String idempotencyToken) {
        this.idempotencyToken = idempotencyToken;
    }

    public String getIdempotencyToken() {
        return this.idempotencyToken;
    }

    public CreateCrossAccountAttachmentRequest withIdempotencyToken(String idempotencyToken) {
        this.setIdempotencyToken(idempotencyToken);
        return this;
    }

    public List<Tag> getTags() {
        return this.tags;
    }

    public void setTags(Collection<Tag> tags) {
        if (tags == null) {
            this.tags = null;
            return;
        }
        this.tags = new ArrayList<Tag>(tags);
    }

    public CreateCrossAccountAttachmentRequest withTags(Tag ... tags) {
        if (this.tags == null) {
            this.setTags(new ArrayList<Tag>(tags.length));
        }
        for (Tag ele : tags) {
            this.tags.add(ele);
        }
        return this;
    }

    public CreateCrossAccountAttachmentRequest withTags(Collection<Tag> tags) {
        this.setTags(tags);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getName() != null) {
            sb.append("Name: ").append(this.getName()).append(",");
        }
        if (this.getPrincipals() != null) {
            sb.append("Principals: ").append(this.getPrincipals()).append(",");
        }
        if (this.getResources() != null) {
            sb.append("Resources: ").append(this.getResources()).append(",");
        }
        if (this.getIdempotencyToken() != null) {
            sb.append("IdempotencyToken: ").append(this.getIdempotencyToken()).append(",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: ").append(this.getTags());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateCrossAccountAttachmentRequest)) {
            return false;
        }
        CreateCrossAccountAttachmentRequest other = (CreateCrossAccountAttachmentRequest)obj;
        if (other.getName() == null ^ this.getName() == null) {
            return false;
        }
        if (other.getName() != null && !other.getName().equals(this.getName())) {
            return false;
        }
        if (other.getPrincipals() == null ^ this.getPrincipals() == null) {
            return false;
        }
        if (other.getPrincipals() != null && !other.getPrincipals().equals(this.getPrincipals())) {
            return false;
        }
        if (other.getResources() == null ^ this.getResources() == null) {
            return false;
        }
        if (other.getResources() != null && !other.getResources().equals(this.getResources())) {
            return false;
        }
        if (other.getIdempotencyToken() == null ^ this.getIdempotencyToken() == null) {
            return false;
        }
        if (other.getIdempotencyToken() != null && !other.getIdempotencyToken().equals(this.getIdempotencyToken())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        return other.getTags() == null || other.getTags().equals(this.getTags());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getName() == null ? 0 : this.getName().hashCode());
        hashCode = 31 * hashCode + (this.getPrincipals() == null ? 0 : this.getPrincipals().hashCode());
        hashCode = 31 * hashCode + (this.getResources() == null ? 0 : this.getResources().hashCode());
        hashCode = 31 * hashCode + (this.getIdempotencyToken() == null ? 0 : this.getIdempotencyToken().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        return hashCode;
    }

    public CreateCrossAccountAttachmentRequest clone() {
        return (CreateCrossAccountAttachmentRequest)super.clone();
    }
}

