/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.glacier.waiters;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.services.glacier.AmazonGlacier;
import com.amazonaws.services.glacier.model.DescribeVaultRequest;
import com.amazonaws.services.glacier.waiters.DescribeVaultFunction;
import com.amazonaws.services.glacier.waiters.VaultExists;
import com.amazonaws.services.glacier.waiters.VaultNotExists;
import com.amazonaws.waiters.FixedDelayStrategy;
import com.amazonaws.waiters.HttpSuccessStatusAcceptor;
import com.amazonaws.waiters.MaxAttemptsRetryStrategy;
import com.amazonaws.waiters.PollingStrategy;
import com.amazonaws.waiters.SdkFunction;
import com.amazonaws.waiters.Waiter;
import com.amazonaws.waiters.WaiterAcceptor;
import com.amazonaws.waiters.WaiterBuilder;
import com.amazonaws.waiters.WaiterState;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class AmazonGlacierWaiters {
    private final AmazonGlacier client;
    private final ExecutorService executorService = Executors.newFixedThreadPool(50);

    @SdkInternalApi
    public AmazonGlacierWaiters(AmazonGlacier client) {
        this.client = client;
    }

    public Waiter<DescribeVaultRequest> vaultExists() {
        return new WaiterBuilder().withSdkFunction((SdkFunction)new DescribeVaultFunction(this.client)).withAcceptors(new WaiterAcceptor[]{new HttpSuccessStatusAcceptor(WaiterState.SUCCESS), new VaultExists.IsResourceNotFoundExceptionMatcher()}).withDefaultPollingStrategy(new PollingStrategy((PollingStrategy.RetryStrategy)new MaxAttemptsRetryStrategy(15), (PollingStrategy.DelayStrategy)new FixedDelayStrategy(3))).withExecutorService(this.executorService).build();
    }

    public Waiter<DescribeVaultRequest> vaultNotExists() {
        return new WaiterBuilder().withSdkFunction((SdkFunction)new DescribeVaultFunction(this.client)).withAcceptors(new WaiterAcceptor[]{new HttpSuccessStatusAcceptor(WaiterState.RETRY), new VaultNotExists.IsResourceNotFoundExceptionMatcher()}).withDefaultPollingStrategy(new PollingStrategy((PollingStrategy.RetryStrategy)new MaxAttemptsRetryStrategy(15), (PollingStrategy.DelayStrategy)new FixedDelayStrategy(3))).withExecutorService(this.executorService).build();
    }

    public void shutdown() {
        this.executorService.shutdown();
    }
}

