/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.gamelift.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonMarshallerFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.gamelift.model.UpdateFleetAttributesRequest;
import com.amazonaws.services.gamelift.model.transform.ResourceCreationLimitPolicyJsonMarshaller;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class UpdateFleetAttributesRequestMarshaller
implements Marshaller<Request<UpdateFleetAttributesRequest>, UpdateFleetAttributesRequest> {
    private final SdkJsonMarshallerFactory protocolFactory;

    public UpdateFleetAttributesRequestMarshaller(SdkJsonMarshallerFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    public Request<UpdateFleetAttributesRequest> marshall(UpdateFleetAttributesRequest updateFleetAttributesRequest) {
        if (updateFleetAttributesRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)updateFleetAttributesRequest, "AmazonGameLift");
        request.addHeader("X-Amz-Target", "GameLift.UpdateFleetAttributes");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (updateFleetAttributesRequest.getFleetId() != null) {
                jsonGenerator.writeFieldName("FleetId").writeValue(updateFleetAttributesRequest.getFleetId());
            }
            if (updateFleetAttributesRequest.getName() != null) {
                jsonGenerator.writeFieldName("Name").writeValue(updateFleetAttributesRequest.getName());
            }
            if (updateFleetAttributesRequest.getDescription() != null) {
                jsonGenerator.writeFieldName("Description").writeValue(updateFleetAttributesRequest.getDescription());
            }
            if (updateFleetAttributesRequest.getNewGameSessionProtectionPolicy() != null) {
                jsonGenerator.writeFieldName("NewGameSessionProtectionPolicy").writeValue(updateFleetAttributesRequest.getNewGameSessionProtectionPolicy());
            }
            if (updateFleetAttributesRequest.getResourceCreationLimitPolicy() != null) {
                jsonGenerator.writeFieldName("ResourceCreationLimitPolicy");
                ResourceCreationLimitPolicyJsonMarshaller.getInstance().marshall(updateFleetAttributesRequest.getResourceCreationLimitPolicy(), jsonGenerator);
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent((InputStream)new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

