/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.gamelift.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.gamelift.model.IpPermission;
import com.amazonaws.services.gamelift.model.UpdateFleetPortSettingsRequest;
import com.amazonaws.services.gamelift.model.transform.IpPermissionJsonMarshaller;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.List;

public class UpdateFleetPortSettingsRequestMarshaller
implements Marshaller<Request<UpdateFleetPortSettingsRequest>, UpdateFleetPortSettingsRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public UpdateFleetPortSettingsRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    public Request<UpdateFleetPortSettingsRequest> marshall(UpdateFleetPortSettingsRequest updateFleetPortSettingsRequest) {
        if (updateFleetPortSettingsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)updateFleetPortSettingsRequest, "AmazonGameLift");
        request.addHeader("X-Amz-Target", "GameLift.UpdateFleetPortSettings");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            List<IpPermission> inboundPermissionRevocationsList;
            List<IpPermission> inboundPermissionAuthorizationsList;
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (updateFleetPortSettingsRequest.getFleetId() != null) {
                jsonGenerator.writeFieldName("FleetId").writeValue(updateFleetPortSettingsRequest.getFleetId());
            }
            if ((inboundPermissionAuthorizationsList = updateFleetPortSettingsRequest.getInboundPermissionAuthorizations()) != null) {
                jsonGenerator.writeFieldName("InboundPermissionAuthorizations");
                jsonGenerator.writeStartArray();
                for (IpPermission ipPermission : inboundPermissionAuthorizationsList) {
                    if (ipPermission == null) continue;
                    IpPermissionJsonMarshaller.getInstance().marshall(ipPermission, jsonGenerator);
                }
                jsonGenerator.writeEndArray();
            }
            if ((inboundPermissionRevocationsList = updateFleetPortSettingsRequest.getInboundPermissionRevocations()) != null) {
                jsonGenerator.writeFieldName("InboundPermissionRevocations");
                jsonGenerator.writeStartArray();
                for (IpPermission inboundPermissionRevocationsListValue : inboundPermissionRevocationsList) {
                    if (inboundPermissionRevocationsListValue == null) continue;
                    IpPermissionJsonMarshaller.getInstance().marshall(inboundPermissionRevocationsListValue, jsonGenerator);
                }
                jsonGenerator.writeEndArray();
            }
            jsonGenerator.writeEndObject();
            byte[] byArray = jsonGenerator.getBytes();
            request.setContent((InputStream)new ByteArrayInputStream(byArray));
            request.addHeader("Content-Length", Integer.toString(byArray.length));
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

