/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.frauddetector.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.frauddetector.model.ModelEndpointStatus;
import com.amazonaws.services.frauddetector.model.ModelInputConfiguration;
import com.amazonaws.services.frauddetector.model.ModelOutputConfiguration;
import com.amazonaws.services.frauddetector.model.ModelSource;
import com.amazonaws.services.frauddetector.model.Tag;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class PutExternalModelRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String modelEndpoint;
    private String modelSource;
    private String invokeModelEndpointRoleArn;
    private ModelInputConfiguration inputConfiguration;
    private ModelOutputConfiguration outputConfiguration;
    private String modelEndpointStatus;
    private List<Tag> tags;

    public void setModelEndpoint(String modelEndpoint) {
        this.modelEndpoint = modelEndpoint;
    }

    public String getModelEndpoint() {
        return this.modelEndpoint;
    }

    public PutExternalModelRequest withModelEndpoint(String modelEndpoint) {
        this.setModelEndpoint(modelEndpoint);
        return this;
    }

    public void setModelSource(String modelSource) {
        this.modelSource = modelSource;
    }

    public String getModelSource() {
        return this.modelSource;
    }

    public PutExternalModelRequest withModelSource(String modelSource) {
        this.setModelSource(modelSource);
        return this;
    }

    public PutExternalModelRequest withModelSource(ModelSource modelSource) {
        this.modelSource = modelSource.toString();
        return this;
    }

    public void setInvokeModelEndpointRoleArn(String invokeModelEndpointRoleArn) {
        this.invokeModelEndpointRoleArn = invokeModelEndpointRoleArn;
    }

    public String getInvokeModelEndpointRoleArn() {
        return this.invokeModelEndpointRoleArn;
    }

    public PutExternalModelRequest withInvokeModelEndpointRoleArn(String invokeModelEndpointRoleArn) {
        this.setInvokeModelEndpointRoleArn(invokeModelEndpointRoleArn);
        return this;
    }

    public void setInputConfiguration(ModelInputConfiguration inputConfiguration) {
        this.inputConfiguration = inputConfiguration;
    }

    public ModelInputConfiguration getInputConfiguration() {
        return this.inputConfiguration;
    }

    public PutExternalModelRequest withInputConfiguration(ModelInputConfiguration inputConfiguration) {
        this.setInputConfiguration(inputConfiguration);
        return this;
    }

    public void setOutputConfiguration(ModelOutputConfiguration outputConfiguration) {
        this.outputConfiguration = outputConfiguration;
    }

    public ModelOutputConfiguration getOutputConfiguration() {
        return this.outputConfiguration;
    }

    public PutExternalModelRequest withOutputConfiguration(ModelOutputConfiguration outputConfiguration) {
        this.setOutputConfiguration(outputConfiguration);
        return this;
    }

    public void setModelEndpointStatus(String modelEndpointStatus) {
        this.modelEndpointStatus = modelEndpointStatus;
    }

    public String getModelEndpointStatus() {
        return this.modelEndpointStatus;
    }

    public PutExternalModelRequest withModelEndpointStatus(String modelEndpointStatus) {
        this.setModelEndpointStatus(modelEndpointStatus);
        return this;
    }

    public PutExternalModelRequest withModelEndpointStatus(ModelEndpointStatus modelEndpointStatus) {
        this.modelEndpointStatus = modelEndpointStatus.toString();
        return this;
    }

    public List<Tag> getTags() {
        return this.tags;
    }

    public void setTags(Collection<Tag> tags) {
        if (tags == null) {
            this.tags = null;
            return;
        }
        this.tags = new ArrayList<Tag>(tags);
    }

    public PutExternalModelRequest withTags(Tag ... tags) {
        if (this.tags == null) {
            this.setTags(new ArrayList<Tag>(tags.length));
        }
        for (Tag ele : tags) {
            this.tags.add(ele);
        }
        return this;
    }

    public PutExternalModelRequest withTags(Collection<Tag> tags) {
        this.setTags(tags);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getModelEndpoint() != null) {
            sb.append("ModelEndpoint: ").append(this.getModelEndpoint()).append(",");
        }
        if (this.getModelSource() != null) {
            sb.append("ModelSource: ").append(this.getModelSource()).append(",");
        }
        if (this.getInvokeModelEndpointRoleArn() != null) {
            sb.append("InvokeModelEndpointRoleArn: ").append(this.getInvokeModelEndpointRoleArn()).append(",");
        }
        if (this.getInputConfiguration() != null) {
            sb.append("InputConfiguration: ").append(this.getInputConfiguration()).append(",");
        }
        if (this.getOutputConfiguration() != null) {
            sb.append("OutputConfiguration: ").append(this.getOutputConfiguration()).append(",");
        }
        if (this.getModelEndpointStatus() != null) {
            sb.append("ModelEndpointStatus: ").append(this.getModelEndpointStatus()).append(",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: ").append(this.getTags());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutExternalModelRequest)) {
            return false;
        }
        PutExternalModelRequest other = (PutExternalModelRequest)obj;
        if (other.getModelEndpoint() == null ^ this.getModelEndpoint() == null) {
            return false;
        }
        if (other.getModelEndpoint() != null && !other.getModelEndpoint().equals(this.getModelEndpoint())) {
            return false;
        }
        if (other.getModelSource() == null ^ this.getModelSource() == null) {
            return false;
        }
        if (other.getModelSource() != null && !other.getModelSource().equals(this.getModelSource())) {
            return false;
        }
        if (other.getInvokeModelEndpointRoleArn() == null ^ this.getInvokeModelEndpointRoleArn() == null) {
            return false;
        }
        if (other.getInvokeModelEndpointRoleArn() != null && !other.getInvokeModelEndpointRoleArn().equals(this.getInvokeModelEndpointRoleArn())) {
            return false;
        }
        if (other.getInputConfiguration() == null ^ this.getInputConfiguration() == null) {
            return false;
        }
        if (other.getInputConfiguration() != null && !other.getInputConfiguration().equals(this.getInputConfiguration())) {
            return false;
        }
        if (other.getOutputConfiguration() == null ^ this.getOutputConfiguration() == null) {
            return false;
        }
        if (other.getOutputConfiguration() != null && !other.getOutputConfiguration().equals(this.getOutputConfiguration())) {
            return false;
        }
        if (other.getModelEndpointStatus() == null ^ this.getModelEndpointStatus() == null) {
            return false;
        }
        if (other.getModelEndpointStatus() != null && !other.getModelEndpointStatus().equals(this.getModelEndpointStatus())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        return other.getTags() == null || other.getTags().equals(this.getTags());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getModelEndpoint() == null ? 0 : this.getModelEndpoint().hashCode());
        hashCode = 31 * hashCode + (this.getModelSource() == null ? 0 : this.getModelSource().hashCode());
        hashCode = 31 * hashCode + (this.getInvokeModelEndpointRoleArn() == null ? 0 : this.getInvokeModelEndpointRoleArn().hashCode());
        hashCode = 31 * hashCode + (this.getInputConfiguration() == null ? 0 : this.getInputConfiguration().hashCode());
        hashCode = 31 * hashCode + (this.getOutputConfiguration() == null ? 0 : this.getOutputConfiguration().hashCode());
        hashCode = 31 * hashCode + (this.getModelEndpointStatus() == null ? 0 : this.getModelEndpointStatus().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        return hashCode;
    }

    public PutExternalModelRequest clone() {
        return (PutExternalModelRequest)super.clone();
    }
}

