/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.frauddetector.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.frauddetector.model.OFIMetricDataPoint;
import com.amazonaws.services.frauddetector.model.OFIModelPerformance;
import com.amazonaws.services.frauddetector.model.transform.OFITrainingMetricsValueMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class OFITrainingMetricsValue
implements Serializable,
Cloneable,
StructuredPojo {
    private List<OFIMetricDataPoint> metricDataPoints;
    private OFIModelPerformance modelPerformance;

    public List<OFIMetricDataPoint> getMetricDataPoints() {
        return this.metricDataPoints;
    }

    public void setMetricDataPoints(Collection<OFIMetricDataPoint> metricDataPoints) {
        if (metricDataPoints == null) {
            this.metricDataPoints = null;
            return;
        }
        this.metricDataPoints = new ArrayList<OFIMetricDataPoint>(metricDataPoints);
    }

    public OFITrainingMetricsValue withMetricDataPoints(OFIMetricDataPoint ... metricDataPoints) {
        if (this.metricDataPoints == null) {
            this.setMetricDataPoints(new ArrayList<OFIMetricDataPoint>(metricDataPoints.length));
        }
        for (OFIMetricDataPoint ele : metricDataPoints) {
            this.metricDataPoints.add(ele);
        }
        return this;
    }

    public OFITrainingMetricsValue withMetricDataPoints(Collection<OFIMetricDataPoint> metricDataPoints) {
        this.setMetricDataPoints(metricDataPoints);
        return this;
    }

    public void setModelPerformance(OFIModelPerformance modelPerformance) {
        this.modelPerformance = modelPerformance;
    }

    public OFIModelPerformance getModelPerformance() {
        return this.modelPerformance;
    }

    public OFITrainingMetricsValue withModelPerformance(OFIModelPerformance modelPerformance) {
        this.setModelPerformance(modelPerformance);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getMetricDataPoints() != null) {
            sb.append("MetricDataPoints: ").append(this.getMetricDataPoints()).append(",");
        }
        if (this.getModelPerformance() != null) {
            sb.append("ModelPerformance: ").append(this.getModelPerformance());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OFITrainingMetricsValue)) {
            return false;
        }
        OFITrainingMetricsValue other = (OFITrainingMetricsValue)obj;
        if (other.getMetricDataPoints() == null ^ this.getMetricDataPoints() == null) {
            return false;
        }
        if (other.getMetricDataPoints() != null && !other.getMetricDataPoints().equals(this.getMetricDataPoints())) {
            return false;
        }
        if (other.getModelPerformance() == null ^ this.getModelPerformance() == null) {
            return false;
        }
        return other.getModelPerformance() == null || other.getModelPerformance().equals(this.getModelPerformance());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getMetricDataPoints() == null ? 0 : this.getMetricDataPoints().hashCode());
        hashCode = 31 * hashCode + (this.getModelPerformance() == null ? 0 : this.getModelPerformance().hashCode());
        return hashCode;
    }

    public OFITrainingMetricsValue clone() {
        try {
            return (OFITrainingMetricsValue)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        OFITrainingMetricsValueMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

