/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.frauddetector.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.frauddetector.model.Tag;
import com.amazonaws.services.frauddetector.model.VariableEntry;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class BatchCreateVariableRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private List<VariableEntry> variableEntries;
    private List<Tag> tags;

    public List<VariableEntry> getVariableEntries() {
        return this.variableEntries;
    }

    public void setVariableEntries(Collection<VariableEntry> variableEntries) {
        if (variableEntries == null) {
            this.variableEntries = null;
            return;
        }
        this.variableEntries = new ArrayList<VariableEntry>(variableEntries);
    }

    public BatchCreateVariableRequest withVariableEntries(VariableEntry ... variableEntries) {
        if (this.variableEntries == null) {
            this.setVariableEntries(new ArrayList<VariableEntry>(variableEntries.length));
        }
        for (VariableEntry ele : variableEntries) {
            this.variableEntries.add(ele);
        }
        return this;
    }

    public BatchCreateVariableRequest withVariableEntries(Collection<VariableEntry> variableEntries) {
        this.setVariableEntries(variableEntries);
        return this;
    }

    public List<Tag> getTags() {
        return this.tags;
    }

    public void setTags(Collection<Tag> tags) {
        if (tags == null) {
            this.tags = null;
            return;
        }
        this.tags = new ArrayList<Tag>(tags);
    }

    public BatchCreateVariableRequest withTags(Tag ... tags) {
        if (this.tags == null) {
            this.setTags(new ArrayList<Tag>(tags.length));
        }
        for (Tag ele : tags) {
            this.tags.add(ele);
        }
        return this;
    }

    public BatchCreateVariableRequest withTags(Collection<Tag> tags) {
        this.setTags(tags);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getVariableEntries() != null) {
            sb.append("VariableEntries: ").append(this.getVariableEntries()).append(",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: ").append(this.getTags());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchCreateVariableRequest)) {
            return false;
        }
        BatchCreateVariableRequest other = (BatchCreateVariableRequest)obj;
        if (other.getVariableEntries() == null ^ this.getVariableEntries() == null) {
            return false;
        }
        if (other.getVariableEntries() != null && !other.getVariableEntries().equals(this.getVariableEntries())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        return other.getTags() == null || other.getTags().equals(this.getTags());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getVariableEntries() == null ? 0 : this.getVariableEntries().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        return hashCode;
    }

    public BatchCreateVariableRequest clone() {
        return (BatchCreateVariableRequest)super.clone();
    }
}

