/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.frauddetector.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.frauddetector.model.ModelVersionEvaluation;
import com.amazonaws.services.frauddetector.model.transform.EvaluatedModelVersionMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class EvaluatedModelVersion
implements Serializable,
Cloneable,
StructuredPojo {
    private String modelId;
    private String modelVersion;
    private String modelType;
    private List<ModelVersionEvaluation> evaluations;

    public void setModelId(String modelId) {
        this.modelId = modelId;
    }

    public String getModelId() {
        return this.modelId;
    }

    public EvaluatedModelVersion withModelId(String modelId) {
        this.setModelId(modelId);
        return this;
    }

    public void setModelVersion(String modelVersion) {
        this.modelVersion = modelVersion;
    }

    public String getModelVersion() {
        return this.modelVersion;
    }

    public EvaluatedModelVersion withModelVersion(String modelVersion) {
        this.setModelVersion(modelVersion);
        return this;
    }

    public void setModelType(String modelType) {
        this.modelType = modelType;
    }

    public String getModelType() {
        return this.modelType;
    }

    public EvaluatedModelVersion withModelType(String modelType) {
        this.setModelType(modelType);
        return this;
    }

    public List<ModelVersionEvaluation> getEvaluations() {
        return this.evaluations;
    }

    public void setEvaluations(Collection<ModelVersionEvaluation> evaluations) {
        if (evaluations == null) {
            this.evaluations = null;
            return;
        }
        this.evaluations = new ArrayList<ModelVersionEvaluation>(evaluations);
    }

    public EvaluatedModelVersion withEvaluations(ModelVersionEvaluation ... evaluations) {
        if (this.evaluations == null) {
            this.setEvaluations(new ArrayList<ModelVersionEvaluation>(evaluations.length));
        }
        for (ModelVersionEvaluation ele : evaluations) {
            this.evaluations.add(ele);
        }
        return this;
    }

    public EvaluatedModelVersion withEvaluations(Collection<ModelVersionEvaluation> evaluations) {
        this.setEvaluations(evaluations);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getModelId() != null) {
            sb.append("ModelId: ").append(this.getModelId()).append(",");
        }
        if (this.getModelVersion() != null) {
            sb.append("ModelVersion: ").append(this.getModelVersion()).append(",");
        }
        if (this.getModelType() != null) {
            sb.append("ModelType: ").append(this.getModelType()).append(",");
        }
        if (this.getEvaluations() != null) {
            sb.append("Evaluations: ").append(this.getEvaluations());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EvaluatedModelVersion)) {
            return false;
        }
        EvaluatedModelVersion other = (EvaluatedModelVersion)obj;
        if (other.getModelId() == null ^ this.getModelId() == null) {
            return false;
        }
        if (other.getModelId() != null && !other.getModelId().equals(this.getModelId())) {
            return false;
        }
        if (other.getModelVersion() == null ^ this.getModelVersion() == null) {
            return false;
        }
        if (other.getModelVersion() != null && !other.getModelVersion().equals(this.getModelVersion())) {
            return false;
        }
        if (other.getModelType() == null ^ this.getModelType() == null) {
            return false;
        }
        if (other.getModelType() != null && !other.getModelType().equals(this.getModelType())) {
            return false;
        }
        if (other.getEvaluations() == null ^ this.getEvaluations() == null) {
            return false;
        }
        return other.getEvaluations() == null || other.getEvaluations().equals(this.getEvaluations());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getModelId() == null ? 0 : this.getModelId().hashCode());
        hashCode = 31 * hashCode + (this.getModelVersion() == null ? 0 : this.getModelVersion().hashCode());
        hashCode = 31 * hashCode + (this.getModelType() == null ? 0 : this.getModelType().hashCode());
        hashCode = 31 * hashCode + (this.getEvaluations() == null ? 0 : this.getEvaluations().hashCode());
        return hashCode;
    }

    public EvaluatedModelVersion clone() {
        try {
            return (EvaluatedModelVersion)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        EvaluatedModelVersionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

