/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.forecast.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.forecast.model.Metrics;
import java.util.List;

@SdkInternalApi
public class MetricsMarshaller {
    private static final MarshallingInfo<Double> RMSE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DOUBLE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RMSE").build();
    private static final MarshallingInfo<List> WEIGHTEDQUANTILELOSSES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("WeightedQuantileLosses").build();
    private static final MarshallingInfo<List> ERRORMETRICS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ErrorMetrics").build();
    private static final MetricsMarshaller instance = new MetricsMarshaller();

    public static MetricsMarshaller getInstance() {
        return instance;
    }

    public void marshall(Metrics metrics, ProtocolMarshaller protocolMarshaller) {
        if (metrics == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)metrics.getRMSE(), RMSE_BINDING);
            protocolMarshaller.marshall(metrics.getWeightedQuantileLosses(), WEIGHTEDQUANTILELOSSES_BINDING);
            protocolMarshaller.marshall(metrics.getErrorMetrics(), ERRORMETRICS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

