/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.fms.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.fms.model.SecurityServiceType;
import com.amazonaws.services.fms.model.transform.PolicyTypeScopeMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class PolicyTypeScope
implements Serializable,
Cloneable,
StructuredPojo {
    private List<String> policyTypes;
    private Boolean allPolicyTypesEnabled;

    public List<String> getPolicyTypes() {
        return this.policyTypes;
    }

    public void setPolicyTypes(Collection<String> policyTypes) {
        if (policyTypes == null) {
            this.policyTypes = null;
            return;
        }
        this.policyTypes = new ArrayList<String>(policyTypes);
    }

    public PolicyTypeScope withPolicyTypes(String ... policyTypes) {
        if (this.policyTypes == null) {
            this.setPolicyTypes(new ArrayList<String>(policyTypes.length));
        }
        for (String ele : policyTypes) {
            this.policyTypes.add(ele);
        }
        return this;
    }

    public PolicyTypeScope withPolicyTypes(Collection<String> policyTypes) {
        this.setPolicyTypes(policyTypes);
        return this;
    }

    public PolicyTypeScope withPolicyTypes(SecurityServiceType ... policyTypes) {
        ArrayList<String> policyTypesCopy = new ArrayList<String>(policyTypes.length);
        for (SecurityServiceType value : policyTypes) {
            policyTypesCopy.add(value.toString());
        }
        if (this.getPolicyTypes() == null) {
            this.setPolicyTypes(policyTypesCopy);
        } else {
            this.getPolicyTypes().addAll(policyTypesCopy);
        }
        return this;
    }

    public void setAllPolicyTypesEnabled(Boolean allPolicyTypesEnabled) {
        this.allPolicyTypesEnabled = allPolicyTypesEnabled;
    }

    public Boolean getAllPolicyTypesEnabled() {
        return this.allPolicyTypesEnabled;
    }

    public PolicyTypeScope withAllPolicyTypesEnabled(Boolean allPolicyTypesEnabled) {
        this.setAllPolicyTypesEnabled(allPolicyTypesEnabled);
        return this;
    }

    public Boolean isAllPolicyTypesEnabled() {
        return this.allPolicyTypesEnabled;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getPolicyTypes() != null) {
            sb.append("PolicyTypes: ").append(this.getPolicyTypes()).append(",");
        }
        if (this.getAllPolicyTypesEnabled() != null) {
            sb.append("AllPolicyTypesEnabled: ").append(this.getAllPolicyTypesEnabled());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PolicyTypeScope)) {
            return false;
        }
        PolicyTypeScope other = (PolicyTypeScope)obj;
        if (other.getPolicyTypes() == null ^ this.getPolicyTypes() == null) {
            return false;
        }
        if (other.getPolicyTypes() != null && !other.getPolicyTypes().equals(this.getPolicyTypes())) {
            return false;
        }
        if (other.getAllPolicyTypesEnabled() == null ^ this.getAllPolicyTypesEnabled() == null) {
            return false;
        }
        return other.getAllPolicyTypesEnabled() == null || other.getAllPolicyTypesEnabled().equals(this.getAllPolicyTypesEnabled());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getPolicyTypes() == null ? 0 : this.getPolicyTypes().hashCode());
        hashCode = 31 * hashCode + (this.getAllPolicyTypesEnabled() == null ? 0 : this.getAllPolicyTypesEnabled().hashCode());
        return hashCode;
    }

    public PolicyTypeScope clone() {
        try {
            return (PolicyTypeScope)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        PolicyTypeScopeMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

