/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.fms.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.fms.model.ViolationReason;
import com.amazonaws.services.fms.model.transform.ComplianceViolatorMarshaller;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class ComplianceViolator
implements Serializable,
Cloneable,
StructuredPojo {
    private String resourceId;
    private String violationReason;
    private String resourceType;
    private Map<String, String> metadata;

    public void setResourceId(String resourceId) {
        this.resourceId = resourceId;
    }

    public String getResourceId() {
        return this.resourceId;
    }

    public ComplianceViolator withResourceId(String resourceId) {
        this.setResourceId(resourceId);
        return this;
    }

    public void setViolationReason(String violationReason) {
        this.violationReason = violationReason;
    }

    public String getViolationReason() {
        return this.violationReason;
    }

    public ComplianceViolator withViolationReason(String violationReason) {
        this.setViolationReason(violationReason);
        return this;
    }

    public ComplianceViolator withViolationReason(ViolationReason violationReason) {
        this.violationReason = violationReason.toString();
        return this;
    }

    public void setResourceType(String resourceType) {
        this.resourceType = resourceType;
    }

    public String getResourceType() {
        return this.resourceType;
    }

    public ComplianceViolator withResourceType(String resourceType) {
        this.setResourceType(resourceType);
        return this;
    }

    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    public void setMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
    }

    public ComplianceViolator withMetadata(Map<String, String> metadata) {
        this.setMetadata(metadata);
        return this;
    }

    public ComplianceViolator addMetadataEntry(String key, String value) {
        if (null == this.metadata) {
            this.metadata = new HashMap<String, String>();
        }
        if (this.metadata.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.metadata.put(key, value);
        return this;
    }

    public ComplianceViolator clearMetadataEntries() {
        this.metadata = null;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getResourceId() != null) {
            sb.append("ResourceId: ").append(this.getResourceId()).append(",");
        }
        if (this.getViolationReason() != null) {
            sb.append("ViolationReason: ").append(this.getViolationReason()).append(",");
        }
        if (this.getResourceType() != null) {
            sb.append("ResourceType: ").append(this.getResourceType()).append(",");
        }
        if (this.getMetadata() != null) {
            sb.append("Metadata: ").append(this.getMetadata());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ComplianceViolator)) {
            return false;
        }
        ComplianceViolator other = (ComplianceViolator)obj;
        if (other.getResourceId() == null ^ this.getResourceId() == null) {
            return false;
        }
        if (other.getResourceId() != null && !other.getResourceId().equals(this.getResourceId())) {
            return false;
        }
        if (other.getViolationReason() == null ^ this.getViolationReason() == null) {
            return false;
        }
        if (other.getViolationReason() != null && !other.getViolationReason().equals(this.getViolationReason())) {
            return false;
        }
        if (other.getResourceType() == null ^ this.getResourceType() == null) {
            return false;
        }
        if (other.getResourceType() != null && !other.getResourceType().equals(this.getResourceType())) {
            return false;
        }
        if (other.getMetadata() == null ^ this.getMetadata() == null) {
            return false;
        }
        return other.getMetadata() == null || other.getMetadata().equals(this.getMetadata());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getResourceId() == null ? 0 : this.getResourceId().hashCode());
        hashCode = 31 * hashCode + (this.getViolationReason() == null ? 0 : this.getViolationReason().hashCode());
        hashCode = 31 * hashCode + (this.getResourceType() == null ? 0 : this.getResourceType().hashCode());
        hashCode = 31 * hashCode + (this.getMetadata() == null ? 0 : this.getMetadata().hashCode());
        return hashCode;
    }

    public ComplianceViolator clone() {
        try {
            return (ComplianceViolator)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ComplianceViolatorMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

