/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.finspacedata.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.services.finspacedata.model.DataViewSummary;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ListDataViewsResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private String nextToken;
    private List<DataViewSummary> dataViews;

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public ListDataViewsResult withNextToken(String nextToken) {
        this.setNextToken(nextToken);
        return this;
    }

    public List<DataViewSummary> getDataViews() {
        return this.dataViews;
    }

    public void setDataViews(Collection<DataViewSummary> dataViews) {
        if (dataViews == null) {
            this.dataViews = null;
            return;
        }
        this.dataViews = new ArrayList<DataViewSummary>(dataViews);
    }

    public ListDataViewsResult withDataViews(DataViewSummary ... dataViews) {
        if (this.dataViews == null) {
            this.setDataViews(new ArrayList<DataViewSummary>(dataViews.length));
        }
        for (DataViewSummary ele : dataViews) {
            this.dataViews.add(ele);
        }
        return this;
    }

    public ListDataViewsResult withDataViews(Collection<DataViewSummary> dataViews) {
        this.setDataViews(dataViews);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getNextToken() != null) {
            sb.append("NextToken: ").append(this.getNextToken()).append(",");
        }
        if (this.getDataViews() != null) {
            sb.append("DataViews: ").append(this.getDataViews());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListDataViewsResult)) {
            return false;
        }
        ListDataViewsResult other = (ListDataViewsResult)obj;
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        if (other.getNextToken() != null && !other.getNextToken().equals(this.getNextToken())) {
            return false;
        }
        if (other.getDataViews() == null ^ this.getDataViews() == null) {
            return false;
        }
        return other.getDataViews() == null || other.getDataViews().equals(this.getDataViews());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        hashCode = 31 * hashCode + (this.getDataViews() == null ? 0 : this.getDataViews().hashCode());
        return hashCode;
    }

    public ListDataViewsResult clone() {
        try {
            return (ListDataViewsResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

