/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.finspace.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.finspace.model.AutoScalingConfiguration;

@SdkInternalApi
public class AutoScalingConfigurationMarshaller {
    private static final MarshallingInfo<Integer> MINNODECOUNT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("minNodeCount").build();
    private static final MarshallingInfo<Integer> MAXNODECOUNT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("maxNodeCount").build();
    private static final MarshallingInfo<String> AUTOSCALINGMETRIC_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("autoScalingMetric").build();
    private static final MarshallingInfo<Double> METRICTARGET_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DOUBLE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("metricTarget").build();
    private static final MarshallingInfo<Double> SCALEINCOOLDOWNSECONDS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DOUBLE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("scaleInCooldownSeconds").build();
    private static final MarshallingInfo<Double> SCALEOUTCOOLDOWNSECONDS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DOUBLE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("scaleOutCooldownSeconds").build();
    private static final AutoScalingConfigurationMarshaller instance = new AutoScalingConfigurationMarshaller();

    public static AutoScalingConfigurationMarshaller getInstance() {
        return instance;
    }

    public void marshall(AutoScalingConfiguration autoScalingConfiguration, ProtocolMarshaller protocolMarshaller) {
        if (autoScalingConfiguration == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)autoScalingConfiguration.getMinNodeCount(), MINNODECOUNT_BINDING);
            protocolMarshaller.marshall((Object)autoScalingConfiguration.getMaxNodeCount(), MAXNODECOUNT_BINDING);
            protocolMarshaller.marshall((Object)autoScalingConfiguration.getAutoScalingMetric(), AUTOSCALINGMETRIC_BINDING);
            protocolMarshaller.marshall((Object)autoScalingConfiguration.getMetricTarget(), METRICTARGET_BINDING);
            protocolMarshaller.marshall((Object)autoScalingConfiguration.getScaleInCooldownSeconds(), SCALEINCOOLDOWNSECONDS_BINDING);
            protocolMarshaller.marshall((Object)autoScalingConfiguration.getScaleOutCooldownSeconds(), SCALEOUTCOOLDOWNSECONDS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

