/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.finspace.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.finspace.model.KxDatabaseCacheConfiguration;
import com.amazonaws.services.finspace.model.KxDataviewConfiguration;
import com.amazonaws.services.finspace.model.transform.KxDatabaseConfigurationMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class KxDatabaseConfiguration
implements Serializable,
Cloneable,
StructuredPojo {
    private String databaseName;
    private List<KxDatabaseCacheConfiguration> cacheConfigurations;
    private String changesetId;
    private String dataviewName;
    private KxDataviewConfiguration dataviewConfiguration;

    public void setDatabaseName(String databaseName) {
        this.databaseName = databaseName;
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public KxDatabaseConfiguration withDatabaseName(String databaseName) {
        this.setDatabaseName(databaseName);
        return this;
    }

    public List<KxDatabaseCacheConfiguration> getCacheConfigurations() {
        return this.cacheConfigurations;
    }

    public void setCacheConfigurations(Collection<KxDatabaseCacheConfiguration> cacheConfigurations) {
        if (cacheConfigurations == null) {
            this.cacheConfigurations = null;
            return;
        }
        this.cacheConfigurations = new ArrayList<KxDatabaseCacheConfiguration>(cacheConfigurations);
    }

    public KxDatabaseConfiguration withCacheConfigurations(KxDatabaseCacheConfiguration ... cacheConfigurations) {
        if (this.cacheConfigurations == null) {
            this.setCacheConfigurations(new ArrayList<KxDatabaseCacheConfiguration>(cacheConfigurations.length));
        }
        for (KxDatabaseCacheConfiguration ele : cacheConfigurations) {
            this.cacheConfigurations.add(ele);
        }
        return this;
    }

    public KxDatabaseConfiguration withCacheConfigurations(Collection<KxDatabaseCacheConfiguration> cacheConfigurations) {
        this.setCacheConfigurations(cacheConfigurations);
        return this;
    }

    public void setChangesetId(String changesetId) {
        this.changesetId = changesetId;
    }

    public String getChangesetId() {
        return this.changesetId;
    }

    public KxDatabaseConfiguration withChangesetId(String changesetId) {
        this.setChangesetId(changesetId);
        return this;
    }

    public void setDataviewName(String dataviewName) {
        this.dataviewName = dataviewName;
    }

    public String getDataviewName() {
        return this.dataviewName;
    }

    public KxDatabaseConfiguration withDataviewName(String dataviewName) {
        this.setDataviewName(dataviewName);
        return this;
    }

    public void setDataviewConfiguration(KxDataviewConfiguration dataviewConfiguration) {
        this.dataviewConfiguration = dataviewConfiguration;
    }

    public KxDataviewConfiguration getDataviewConfiguration() {
        return this.dataviewConfiguration;
    }

    public KxDatabaseConfiguration withDataviewConfiguration(KxDataviewConfiguration dataviewConfiguration) {
        this.setDataviewConfiguration(dataviewConfiguration);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getDatabaseName() != null) {
            sb.append("DatabaseName: ").append(this.getDatabaseName()).append(",");
        }
        if (this.getCacheConfigurations() != null) {
            sb.append("CacheConfigurations: ").append(this.getCacheConfigurations()).append(",");
        }
        if (this.getChangesetId() != null) {
            sb.append("ChangesetId: ").append(this.getChangesetId()).append(",");
        }
        if (this.getDataviewName() != null) {
            sb.append("DataviewName: ").append(this.getDataviewName()).append(",");
        }
        if (this.getDataviewConfiguration() != null) {
            sb.append("DataviewConfiguration: ").append(this.getDataviewConfiguration());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof KxDatabaseConfiguration)) {
            return false;
        }
        KxDatabaseConfiguration other = (KxDatabaseConfiguration)obj;
        if (other.getDatabaseName() == null ^ this.getDatabaseName() == null) {
            return false;
        }
        if (other.getDatabaseName() != null && !other.getDatabaseName().equals(this.getDatabaseName())) {
            return false;
        }
        if (other.getCacheConfigurations() == null ^ this.getCacheConfigurations() == null) {
            return false;
        }
        if (other.getCacheConfigurations() != null && !other.getCacheConfigurations().equals(this.getCacheConfigurations())) {
            return false;
        }
        if (other.getChangesetId() == null ^ this.getChangesetId() == null) {
            return false;
        }
        if (other.getChangesetId() != null && !other.getChangesetId().equals(this.getChangesetId())) {
            return false;
        }
        if (other.getDataviewName() == null ^ this.getDataviewName() == null) {
            return false;
        }
        if (other.getDataviewName() != null && !other.getDataviewName().equals(this.getDataviewName())) {
            return false;
        }
        if (other.getDataviewConfiguration() == null ^ this.getDataviewConfiguration() == null) {
            return false;
        }
        return other.getDataviewConfiguration() == null || other.getDataviewConfiguration().equals(this.getDataviewConfiguration());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getDatabaseName() == null ? 0 : this.getDatabaseName().hashCode());
        hashCode = 31 * hashCode + (this.getCacheConfigurations() == null ? 0 : this.getCacheConfigurations().hashCode());
        hashCode = 31 * hashCode + (this.getChangesetId() == null ? 0 : this.getChangesetId().hashCode());
        hashCode = 31 * hashCode + (this.getDataviewName() == null ? 0 : this.getDataviewName().hashCode());
        hashCode = 31 * hashCode + (this.getDataviewConfiguration() == null ? 0 : this.getDataviewConfiguration().hashCode());
        return hashCode;
    }

    public KxDatabaseConfiguration clone() {
        try {
            return (KxDatabaseConfiguration)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        KxDatabaseConfigurationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

