/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.finspace.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.finspace.model.KxAzMode;
import com.amazonaws.services.finspace.model.KxClusterStatus;
import com.amazonaws.services.finspace.model.KxClusterType;
import com.amazonaws.services.finspace.model.Volume;
import com.amazonaws.services.finspace.model.transform.KxClusterMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;

public class KxCluster
implements Serializable,
Cloneable,
StructuredPojo {
    private String status;
    private String statusReason;
    private String clusterName;
    private String clusterType;
    private String clusterDescription;
    private String releaseLabel;
    private List<Volume> volumes;
    private String initializationScript;
    private String executionRole;
    private String azMode;
    private String availabilityZoneId;
    private Date lastModifiedTimestamp;
    private Date createdTimestamp;

    public void setStatus(String status) {
        this.status = status;
    }

    public String getStatus() {
        return this.status;
    }

    public KxCluster withStatus(String status) {
        this.setStatus(status);
        return this;
    }

    public KxCluster withStatus(KxClusterStatus status) {
        this.status = status.toString();
        return this;
    }

    public void setStatusReason(String statusReason) {
        this.statusReason = statusReason;
    }

    public String getStatusReason() {
        return this.statusReason;
    }

    public KxCluster withStatusReason(String statusReason) {
        this.setStatusReason(statusReason);
        return this;
    }

    public void setClusterName(String clusterName) {
        this.clusterName = clusterName;
    }

    public String getClusterName() {
        return this.clusterName;
    }

    public KxCluster withClusterName(String clusterName) {
        this.setClusterName(clusterName);
        return this;
    }

    public void setClusterType(String clusterType) {
        this.clusterType = clusterType;
    }

    public String getClusterType() {
        return this.clusterType;
    }

    public KxCluster withClusterType(String clusterType) {
        this.setClusterType(clusterType);
        return this;
    }

    public KxCluster withClusterType(KxClusterType clusterType) {
        this.clusterType = clusterType.toString();
        return this;
    }

    public void setClusterDescription(String clusterDescription) {
        this.clusterDescription = clusterDescription;
    }

    public String getClusterDescription() {
        return this.clusterDescription;
    }

    public KxCluster withClusterDescription(String clusterDescription) {
        this.setClusterDescription(clusterDescription);
        return this;
    }

    public void setReleaseLabel(String releaseLabel) {
        this.releaseLabel = releaseLabel;
    }

    public String getReleaseLabel() {
        return this.releaseLabel;
    }

    public KxCluster withReleaseLabel(String releaseLabel) {
        this.setReleaseLabel(releaseLabel);
        return this;
    }

    public List<Volume> getVolumes() {
        return this.volumes;
    }

    public void setVolumes(Collection<Volume> volumes) {
        if (volumes == null) {
            this.volumes = null;
            return;
        }
        this.volumes = new ArrayList<Volume>(volumes);
    }

    public KxCluster withVolumes(Volume ... volumes) {
        if (this.volumes == null) {
            this.setVolumes(new ArrayList<Volume>(volumes.length));
        }
        for (Volume ele : volumes) {
            this.volumes.add(ele);
        }
        return this;
    }

    public KxCluster withVolumes(Collection<Volume> volumes) {
        this.setVolumes(volumes);
        return this;
    }

    public void setInitializationScript(String initializationScript) {
        this.initializationScript = initializationScript;
    }

    public String getInitializationScript() {
        return this.initializationScript;
    }

    public KxCluster withInitializationScript(String initializationScript) {
        this.setInitializationScript(initializationScript);
        return this;
    }

    public void setExecutionRole(String executionRole) {
        this.executionRole = executionRole;
    }

    public String getExecutionRole() {
        return this.executionRole;
    }

    public KxCluster withExecutionRole(String executionRole) {
        this.setExecutionRole(executionRole);
        return this;
    }

    public void setAzMode(String azMode) {
        this.azMode = azMode;
    }

    public String getAzMode() {
        return this.azMode;
    }

    public KxCluster withAzMode(String azMode) {
        this.setAzMode(azMode);
        return this;
    }

    public KxCluster withAzMode(KxAzMode azMode) {
        this.azMode = azMode.toString();
        return this;
    }

    public void setAvailabilityZoneId(String availabilityZoneId) {
        this.availabilityZoneId = availabilityZoneId;
    }

    public String getAvailabilityZoneId() {
        return this.availabilityZoneId;
    }

    public KxCluster withAvailabilityZoneId(String availabilityZoneId) {
        this.setAvailabilityZoneId(availabilityZoneId);
        return this;
    }

    public void setLastModifiedTimestamp(Date lastModifiedTimestamp) {
        this.lastModifiedTimestamp = lastModifiedTimestamp;
    }

    public Date getLastModifiedTimestamp() {
        return this.lastModifiedTimestamp;
    }

    public KxCluster withLastModifiedTimestamp(Date lastModifiedTimestamp) {
        this.setLastModifiedTimestamp(lastModifiedTimestamp);
        return this;
    }

    public void setCreatedTimestamp(Date createdTimestamp) {
        this.createdTimestamp = createdTimestamp;
    }

    public Date getCreatedTimestamp() {
        return this.createdTimestamp;
    }

    public KxCluster withCreatedTimestamp(Date createdTimestamp) {
        this.setCreatedTimestamp(createdTimestamp);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getStatus() != null) {
            sb.append("Status: ").append(this.getStatus()).append(",");
        }
        if (this.getStatusReason() != null) {
            sb.append("StatusReason: ").append(this.getStatusReason()).append(",");
        }
        if (this.getClusterName() != null) {
            sb.append("ClusterName: ").append(this.getClusterName()).append(",");
        }
        if (this.getClusterType() != null) {
            sb.append("ClusterType: ").append(this.getClusterType()).append(",");
        }
        if (this.getClusterDescription() != null) {
            sb.append("ClusterDescription: ").append(this.getClusterDescription()).append(",");
        }
        if (this.getReleaseLabel() != null) {
            sb.append("ReleaseLabel: ").append(this.getReleaseLabel()).append(",");
        }
        if (this.getVolumes() != null) {
            sb.append("Volumes: ").append(this.getVolumes()).append(",");
        }
        if (this.getInitializationScript() != null) {
            sb.append("InitializationScript: ").append(this.getInitializationScript()).append(",");
        }
        if (this.getExecutionRole() != null) {
            sb.append("ExecutionRole: ").append(this.getExecutionRole()).append(",");
        }
        if (this.getAzMode() != null) {
            sb.append("AzMode: ").append(this.getAzMode()).append(",");
        }
        if (this.getAvailabilityZoneId() != null) {
            sb.append("AvailabilityZoneId: ").append(this.getAvailabilityZoneId()).append(",");
        }
        if (this.getLastModifiedTimestamp() != null) {
            sb.append("LastModifiedTimestamp: ").append(this.getLastModifiedTimestamp()).append(",");
        }
        if (this.getCreatedTimestamp() != null) {
            sb.append("CreatedTimestamp: ").append(this.getCreatedTimestamp());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof KxCluster)) {
            return false;
        }
        KxCluster other = (KxCluster)obj;
        if (other.getStatus() == null ^ this.getStatus() == null) {
            return false;
        }
        if (other.getStatus() != null && !other.getStatus().equals(this.getStatus())) {
            return false;
        }
        if (other.getStatusReason() == null ^ this.getStatusReason() == null) {
            return false;
        }
        if (other.getStatusReason() != null && !other.getStatusReason().equals(this.getStatusReason())) {
            return false;
        }
        if (other.getClusterName() == null ^ this.getClusterName() == null) {
            return false;
        }
        if (other.getClusterName() != null && !other.getClusterName().equals(this.getClusterName())) {
            return false;
        }
        if (other.getClusterType() == null ^ this.getClusterType() == null) {
            return false;
        }
        if (other.getClusterType() != null && !other.getClusterType().equals(this.getClusterType())) {
            return false;
        }
        if (other.getClusterDescription() == null ^ this.getClusterDescription() == null) {
            return false;
        }
        if (other.getClusterDescription() != null && !other.getClusterDescription().equals(this.getClusterDescription())) {
            return false;
        }
        if (other.getReleaseLabel() == null ^ this.getReleaseLabel() == null) {
            return false;
        }
        if (other.getReleaseLabel() != null && !other.getReleaseLabel().equals(this.getReleaseLabel())) {
            return false;
        }
        if (other.getVolumes() == null ^ this.getVolumes() == null) {
            return false;
        }
        if (other.getVolumes() != null && !other.getVolumes().equals(this.getVolumes())) {
            return false;
        }
        if (other.getInitializationScript() == null ^ this.getInitializationScript() == null) {
            return false;
        }
        if (other.getInitializationScript() != null && !other.getInitializationScript().equals(this.getInitializationScript())) {
            return false;
        }
        if (other.getExecutionRole() == null ^ this.getExecutionRole() == null) {
            return false;
        }
        if (other.getExecutionRole() != null && !other.getExecutionRole().equals(this.getExecutionRole())) {
            return false;
        }
        if (other.getAzMode() == null ^ this.getAzMode() == null) {
            return false;
        }
        if (other.getAzMode() != null && !other.getAzMode().equals(this.getAzMode())) {
            return false;
        }
        if (other.getAvailabilityZoneId() == null ^ this.getAvailabilityZoneId() == null) {
            return false;
        }
        if (other.getAvailabilityZoneId() != null && !other.getAvailabilityZoneId().equals(this.getAvailabilityZoneId())) {
            return false;
        }
        if (other.getLastModifiedTimestamp() == null ^ this.getLastModifiedTimestamp() == null) {
            return false;
        }
        if (other.getLastModifiedTimestamp() != null && !other.getLastModifiedTimestamp().equals(this.getLastModifiedTimestamp())) {
            return false;
        }
        if (other.getCreatedTimestamp() == null ^ this.getCreatedTimestamp() == null) {
            return false;
        }
        return other.getCreatedTimestamp() == null || other.getCreatedTimestamp().equals(this.getCreatedTimestamp());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getStatus() == null ? 0 : this.getStatus().hashCode());
        hashCode = 31 * hashCode + (this.getStatusReason() == null ? 0 : this.getStatusReason().hashCode());
        hashCode = 31 * hashCode + (this.getClusterName() == null ? 0 : this.getClusterName().hashCode());
        hashCode = 31 * hashCode + (this.getClusterType() == null ? 0 : this.getClusterType().hashCode());
        hashCode = 31 * hashCode + (this.getClusterDescription() == null ? 0 : this.getClusterDescription().hashCode());
        hashCode = 31 * hashCode + (this.getReleaseLabel() == null ? 0 : this.getReleaseLabel().hashCode());
        hashCode = 31 * hashCode + (this.getVolumes() == null ? 0 : this.getVolumes().hashCode());
        hashCode = 31 * hashCode + (this.getInitializationScript() == null ? 0 : this.getInitializationScript().hashCode());
        hashCode = 31 * hashCode + (this.getExecutionRole() == null ? 0 : this.getExecutionRole().hashCode());
        hashCode = 31 * hashCode + (this.getAzMode() == null ? 0 : this.getAzMode().hashCode());
        hashCode = 31 * hashCode + (this.getAvailabilityZoneId() == null ? 0 : this.getAvailabilityZoneId().hashCode());
        hashCode = 31 * hashCode + (this.getLastModifiedTimestamp() == null ? 0 : this.getLastModifiedTimestamp().hashCode());
        hashCode = 31 * hashCode + (this.getCreatedTimestamp() == null ? 0 : this.getCreatedTimestamp().hashCode());
        return hashCode;
    }

    public KxCluster clone() {
        try {
            return (KxCluster)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        KxClusterMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

