/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.entityresolution;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.client.AwsAsyncClientParams;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.entityresolution.AWSEntityResolutionAsync;
import com.amazonaws.services.entityresolution.AWSEntityResolutionAsyncClientBuilder;
import com.amazonaws.services.entityresolution.AWSEntityResolutionClient;
import com.amazonaws.services.entityresolution.model.CreateMatchingWorkflowRequest;
import com.amazonaws.services.entityresolution.model.CreateMatchingWorkflowResult;
import com.amazonaws.services.entityresolution.model.CreateSchemaMappingRequest;
import com.amazonaws.services.entityresolution.model.CreateSchemaMappingResult;
import com.amazonaws.services.entityresolution.model.DeleteMatchingWorkflowRequest;
import com.amazonaws.services.entityresolution.model.DeleteMatchingWorkflowResult;
import com.amazonaws.services.entityresolution.model.DeleteSchemaMappingRequest;
import com.amazonaws.services.entityresolution.model.DeleteSchemaMappingResult;
import com.amazonaws.services.entityresolution.model.GetMatchIdRequest;
import com.amazonaws.services.entityresolution.model.GetMatchIdResult;
import com.amazonaws.services.entityresolution.model.GetMatchingJobRequest;
import com.amazonaws.services.entityresolution.model.GetMatchingJobResult;
import com.amazonaws.services.entityresolution.model.GetMatchingWorkflowRequest;
import com.amazonaws.services.entityresolution.model.GetMatchingWorkflowResult;
import com.amazonaws.services.entityresolution.model.GetSchemaMappingRequest;
import com.amazonaws.services.entityresolution.model.GetSchemaMappingResult;
import com.amazonaws.services.entityresolution.model.ListMatchingJobsRequest;
import com.amazonaws.services.entityresolution.model.ListMatchingJobsResult;
import com.amazonaws.services.entityresolution.model.ListMatchingWorkflowsRequest;
import com.amazonaws.services.entityresolution.model.ListMatchingWorkflowsResult;
import com.amazonaws.services.entityresolution.model.ListSchemaMappingsRequest;
import com.amazonaws.services.entityresolution.model.ListSchemaMappingsResult;
import com.amazonaws.services.entityresolution.model.ListTagsForResourceRequest;
import com.amazonaws.services.entityresolution.model.ListTagsForResourceResult;
import com.amazonaws.services.entityresolution.model.StartMatchingJobRequest;
import com.amazonaws.services.entityresolution.model.StartMatchingJobResult;
import com.amazonaws.services.entityresolution.model.TagResourceRequest;
import com.amazonaws.services.entityresolution.model.TagResourceResult;
import com.amazonaws.services.entityresolution.model.UntagResourceRequest;
import com.amazonaws.services.entityresolution.model.UntagResourceResult;
import com.amazonaws.services.entityresolution.model.UpdateMatchingWorkflowRequest;
import com.amazonaws.services.entityresolution.model.UpdateMatchingWorkflowResult;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;

@ThreadSafe
public class AWSEntityResolutionAsyncClient
extends AWSEntityResolutionClient
implements AWSEntityResolutionAsync {
    private static final int DEFAULT_THREAD_POOL_SIZE = 50;
    private final ExecutorService executorService;

    public static AWSEntityResolutionAsyncClientBuilder asyncBuilder() {
        return AWSEntityResolutionAsyncClientBuilder.standard();
    }

    AWSEntityResolutionAsyncClient(AwsAsyncClientParams asyncClientParams) {
        this(asyncClientParams, false);
    }

    AWSEntityResolutionAsyncClient(AwsAsyncClientParams asyncClientParams, boolean endpointDiscoveryEnabled) {
        super((AwsSyncClientParams)asyncClientParams, endpointDiscoveryEnabled);
        this.executorService = asyncClientParams.getExecutor();
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public Future<CreateMatchingWorkflowResult> createMatchingWorkflowAsync(CreateMatchingWorkflowRequest request) {
        return this.createMatchingWorkflowAsync(request, null);
    }

    @Override
    public Future<CreateMatchingWorkflowResult> createMatchingWorkflowAsync(CreateMatchingWorkflowRequest request, final AsyncHandler<CreateMatchingWorkflowRequest, CreateMatchingWorkflowResult> asyncHandler) {
        final CreateMatchingWorkflowRequest finalRequest = (CreateMatchingWorkflowRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateMatchingWorkflowResult>(){

            @Override
            public CreateMatchingWorkflowResult call() throws Exception {
                CreateMatchingWorkflowResult result = null;
                try {
                    result = AWSEntityResolutionAsyncClient.this.executeCreateMatchingWorkflow(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateSchemaMappingResult> createSchemaMappingAsync(CreateSchemaMappingRequest request) {
        return this.createSchemaMappingAsync(request, null);
    }

    @Override
    public Future<CreateSchemaMappingResult> createSchemaMappingAsync(CreateSchemaMappingRequest request, final AsyncHandler<CreateSchemaMappingRequest, CreateSchemaMappingResult> asyncHandler) {
        final CreateSchemaMappingRequest finalRequest = (CreateSchemaMappingRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateSchemaMappingResult>(){

            @Override
            public CreateSchemaMappingResult call() throws Exception {
                CreateSchemaMappingResult result = null;
                try {
                    result = AWSEntityResolutionAsyncClient.this.executeCreateSchemaMapping(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteMatchingWorkflowResult> deleteMatchingWorkflowAsync(DeleteMatchingWorkflowRequest request) {
        return this.deleteMatchingWorkflowAsync(request, null);
    }

    @Override
    public Future<DeleteMatchingWorkflowResult> deleteMatchingWorkflowAsync(DeleteMatchingWorkflowRequest request, final AsyncHandler<DeleteMatchingWorkflowRequest, DeleteMatchingWorkflowResult> asyncHandler) {
        final DeleteMatchingWorkflowRequest finalRequest = (DeleteMatchingWorkflowRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteMatchingWorkflowResult>(){

            @Override
            public DeleteMatchingWorkflowResult call() throws Exception {
                DeleteMatchingWorkflowResult result = null;
                try {
                    result = AWSEntityResolutionAsyncClient.this.executeDeleteMatchingWorkflow(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteSchemaMappingResult> deleteSchemaMappingAsync(DeleteSchemaMappingRequest request) {
        return this.deleteSchemaMappingAsync(request, null);
    }

    @Override
    public Future<DeleteSchemaMappingResult> deleteSchemaMappingAsync(DeleteSchemaMappingRequest request, final AsyncHandler<DeleteSchemaMappingRequest, DeleteSchemaMappingResult> asyncHandler) {
        final DeleteSchemaMappingRequest finalRequest = (DeleteSchemaMappingRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteSchemaMappingResult>(){

            @Override
            public DeleteSchemaMappingResult call() throws Exception {
                DeleteSchemaMappingResult result = null;
                try {
                    result = AWSEntityResolutionAsyncClient.this.executeDeleteSchemaMapping(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetMatchIdResult> getMatchIdAsync(GetMatchIdRequest request) {
        return this.getMatchIdAsync(request, null);
    }

    @Override
    public Future<GetMatchIdResult> getMatchIdAsync(GetMatchIdRequest request, final AsyncHandler<GetMatchIdRequest, GetMatchIdResult> asyncHandler) {
        final GetMatchIdRequest finalRequest = (GetMatchIdRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetMatchIdResult>(){

            @Override
            public GetMatchIdResult call() throws Exception {
                GetMatchIdResult result = null;
                try {
                    result = AWSEntityResolutionAsyncClient.this.executeGetMatchId(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetMatchingJobResult> getMatchingJobAsync(GetMatchingJobRequest request) {
        return this.getMatchingJobAsync(request, null);
    }

    @Override
    public Future<GetMatchingJobResult> getMatchingJobAsync(GetMatchingJobRequest request, final AsyncHandler<GetMatchingJobRequest, GetMatchingJobResult> asyncHandler) {
        final GetMatchingJobRequest finalRequest = (GetMatchingJobRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetMatchingJobResult>(){

            @Override
            public GetMatchingJobResult call() throws Exception {
                GetMatchingJobResult result = null;
                try {
                    result = AWSEntityResolutionAsyncClient.this.executeGetMatchingJob(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetMatchingWorkflowResult> getMatchingWorkflowAsync(GetMatchingWorkflowRequest request) {
        return this.getMatchingWorkflowAsync(request, null);
    }

    @Override
    public Future<GetMatchingWorkflowResult> getMatchingWorkflowAsync(GetMatchingWorkflowRequest request, final AsyncHandler<GetMatchingWorkflowRequest, GetMatchingWorkflowResult> asyncHandler) {
        final GetMatchingWorkflowRequest finalRequest = (GetMatchingWorkflowRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetMatchingWorkflowResult>(){

            @Override
            public GetMatchingWorkflowResult call() throws Exception {
                GetMatchingWorkflowResult result = null;
                try {
                    result = AWSEntityResolutionAsyncClient.this.executeGetMatchingWorkflow(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetSchemaMappingResult> getSchemaMappingAsync(GetSchemaMappingRequest request) {
        return this.getSchemaMappingAsync(request, null);
    }

    @Override
    public Future<GetSchemaMappingResult> getSchemaMappingAsync(GetSchemaMappingRequest request, final AsyncHandler<GetSchemaMappingRequest, GetSchemaMappingResult> asyncHandler) {
        final GetSchemaMappingRequest finalRequest = (GetSchemaMappingRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetSchemaMappingResult>(){

            @Override
            public GetSchemaMappingResult call() throws Exception {
                GetSchemaMappingResult result = null;
                try {
                    result = AWSEntityResolutionAsyncClient.this.executeGetSchemaMapping(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListMatchingJobsResult> listMatchingJobsAsync(ListMatchingJobsRequest request) {
        return this.listMatchingJobsAsync(request, null);
    }

    @Override
    public Future<ListMatchingJobsResult> listMatchingJobsAsync(ListMatchingJobsRequest request, final AsyncHandler<ListMatchingJobsRequest, ListMatchingJobsResult> asyncHandler) {
        final ListMatchingJobsRequest finalRequest = (ListMatchingJobsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListMatchingJobsResult>(){

            @Override
            public ListMatchingJobsResult call() throws Exception {
                ListMatchingJobsResult result = null;
                try {
                    result = AWSEntityResolutionAsyncClient.this.executeListMatchingJobs(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListMatchingWorkflowsResult> listMatchingWorkflowsAsync(ListMatchingWorkflowsRequest request) {
        return this.listMatchingWorkflowsAsync(request, null);
    }

    @Override
    public Future<ListMatchingWorkflowsResult> listMatchingWorkflowsAsync(ListMatchingWorkflowsRequest request, final AsyncHandler<ListMatchingWorkflowsRequest, ListMatchingWorkflowsResult> asyncHandler) {
        final ListMatchingWorkflowsRequest finalRequest = (ListMatchingWorkflowsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListMatchingWorkflowsResult>(){

            @Override
            public ListMatchingWorkflowsResult call() throws Exception {
                ListMatchingWorkflowsResult result = null;
                try {
                    result = AWSEntityResolutionAsyncClient.this.executeListMatchingWorkflows(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListSchemaMappingsResult> listSchemaMappingsAsync(ListSchemaMappingsRequest request) {
        return this.listSchemaMappingsAsync(request, null);
    }

    @Override
    public Future<ListSchemaMappingsResult> listSchemaMappingsAsync(ListSchemaMappingsRequest request, final AsyncHandler<ListSchemaMappingsRequest, ListSchemaMappingsResult> asyncHandler) {
        final ListSchemaMappingsRequest finalRequest = (ListSchemaMappingsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListSchemaMappingsResult>(){

            @Override
            public ListSchemaMappingsResult call() throws Exception {
                ListSchemaMappingsResult result = null;
                try {
                    result = AWSEntityResolutionAsyncClient.this.executeListSchemaMappings(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListTagsForResourceResult> listTagsForResourceAsync(ListTagsForResourceRequest request) {
        return this.listTagsForResourceAsync(request, null);
    }

    @Override
    public Future<ListTagsForResourceResult> listTagsForResourceAsync(ListTagsForResourceRequest request, final AsyncHandler<ListTagsForResourceRequest, ListTagsForResourceResult> asyncHandler) {
        final ListTagsForResourceRequest finalRequest = (ListTagsForResourceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListTagsForResourceResult>(){

            @Override
            public ListTagsForResourceResult call() throws Exception {
                ListTagsForResourceResult result = null;
                try {
                    result = AWSEntityResolutionAsyncClient.this.executeListTagsForResource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<StartMatchingJobResult> startMatchingJobAsync(StartMatchingJobRequest request) {
        return this.startMatchingJobAsync(request, null);
    }

    @Override
    public Future<StartMatchingJobResult> startMatchingJobAsync(StartMatchingJobRequest request, final AsyncHandler<StartMatchingJobRequest, StartMatchingJobResult> asyncHandler) {
        final StartMatchingJobRequest finalRequest = (StartMatchingJobRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<StartMatchingJobResult>(){

            @Override
            public StartMatchingJobResult call() throws Exception {
                StartMatchingJobResult result = null;
                try {
                    result = AWSEntityResolutionAsyncClient.this.executeStartMatchingJob(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<TagResourceResult> tagResourceAsync(TagResourceRequest request) {
        return this.tagResourceAsync(request, null);
    }

    @Override
    public Future<TagResourceResult> tagResourceAsync(TagResourceRequest request, final AsyncHandler<TagResourceRequest, TagResourceResult> asyncHandler) {
        final TagResourceRequest finalRequest = (TagResourceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<TagResourceResult>(){

            @Override
            public TagResourceResult call() throws Exception {
                TagResourceResult result = null;
                try {
                    result = AWSEntityResolutionAsyncClient.this.executeTagResource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UntagResourceResult> untagResourceAsync(UntagResourceRequest request) {
        return this.untagResourceAsync(request, null);
    }

    @Override
    public Future<UntagResourceResult> untagResourceAsync(UntagResourceRequest request, final AsyncHandler<UntagResourceRequest, UntagResourceResult> asyncHandler) {
        final UntagResourceRequest finalRequest = (UntagResourceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UntagResourceResult>(){

            @Override
            public UntagResourceResult call() throws Exception {
                UntagResourceResult result = null;
                try {
                    result = AWSEntityResolutionAsyncClient.this.executeUntagResource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateMatchingWorkflowResult> updateMatchingWorkflowAsync(UpdateMatchingWorkflowRequest request) {
        return this.updateMatchingWorkflowAsync(request, null);
    }

    @Override
    public Future<UpdateMatchingWorkflowResult> updateMatchingWorkflowAsync(UpdateMatchingWorkflowRequest request, final AsyncHandler<UpdateMatchingWorkflowRequest, UpdateMatchingWorkflowResult> asyncHandler) {
        final UpdateMatchingWorkflowRequest finalRequest = (UpdateMatchingWorkflowRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UpdateMatchingWorkflowResult>(){

            @Override
            public UpdateMatchingWorkflowResult call() throws Exception {
                UpdateMatchingWorkflowResult result = null;
                try {
                    result = AWSEntityResolutionAsyncClient.this.executeUpdateMatchingWorkflow(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }
}

