/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticmapreduce.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.elasticmapreduce.model.Configuration;
import com.amazonaws.services.elasticmapreduce.model.EbsBlockDevice;
import com.amazonaws.services.elasticmapreduce.model.transform.InstanceTypeSpecificationMarshaller;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class InstanceTypeSpecification
implements Serializable,
Cloneable,
StructuredPojo {
    private String instanceType;
    private Integer weightedCapacity;
    private String bidPrice;
    private Double bidPriceAsPercentageOfOnDemandPrice;
    private SdkInternalList<Configuration> configurations;
    private SdkInternalList<EbsBlockDevice> ebsBlockDevices;
    private Boolean ebsOptimized;
    private String customAmiId;
    private Double priority;

    public void setInstanceType(String instanceType) {
        this.instanceType = instanceType;
    }

    public String getInstanceType() {
        return this.instanceType;
    }

    public InstanceTypeSpecification withInstanceType(String instanceType) {
        this.setInstanceType(instanceType);
        return this;
    }

    public void setWeightedCapacity(Integer weightedCapacity) {
        this.weightedCapacity = weightedCapacity;
    }

    public Integer getWeightedCapacity() {
        return this.weightedCapacity;
    }

    public InstanceTypeSpecification withWeightedCapacity(Integer weightedCapacity) {
        this.setWeightedCapacity(weightedCapacity);
        return this;
    }

    public void setBidPrice(String bidPrice) {
        this.bidPrice = bidPrice;
    }

    public String getBidPrice() {
        return this.bidPrice;
    }

    public InstanceTypeSpecification withBidPrice(String bidPrice) {
        this.setBidPrice(bidPrice);
        return this;
    }

    public void setBidPriceAsPercentageOfOnDemandPrice(Double bidPriceAsPercentageOfOnDemandPrice) {
        this.bidPriceAsPercentageOfOnDemandPrice = bidPriceAsPercentageOfOnDemandPrice;
    }

    public Double getBidPriceAsPercentageOfOnDemandPrice() {
        return this.bidPriceAsPercentageOfOnDemandPrice;
    }

    public InstanceTypeSpecification withBidPriceAsPercentageOfOnDemandPrice(Double bidPriceAsPercentageOfOnDemandPrice) {
        this.setBidPriceAsPercentageOfOnDemandPrice(bidPriceAsPercentageOfOnDemandPrice);
        return this;
    }

    public List<Configuration> getConfigurations() {
        if (this.configurations == null) {
            this.configurations = new SdkInternalList();
        }
        return this.configurations;
    }

    public void setConfigurations(Collection<Configuration> configurations) {
        if (configurations == null) {
            this.configurations = null;
            return;
        }
        this.configurations = new SdkInternalList(configurations);
    }

    public InstanceTypeSpecification withConfigurations(Configuration ... configurations) {
        if (this.configurations == null) {
            this.setConfigurations((Collection<Configuration>)new SdkInternalList(configurations.length));
        }
        for (Configuration ele : configurations) {
            this.configurations.add((Object)ele);
        }
        return this;
    }

    public InstanceTypeSpecification withConfigurations(Collection<Configuration> configurations) {
        this.setConfigurations(configurations);
        return this;
    }

    public List<EbsBlockDevice> getEbsBlockDevices() {
        if (this.ebsBlockDevices == null) {
            this.ebsBlockDevices = new SdkInternalList();
        }
        return this.ebsBlockDevices;
    }

    public void setEbsBlockDevices(Collection<EbsBlockDevice> ebsBlockDevices) {
        if (ebsBlockDevices == null) {
            this.ebsBlockDevices = null;
            return;
        }
        this.ebsBlockDevices = new SdkInternalList(ebsBlockDevices);
    }

    public InstanceTypeSpecification withEbsBlockDevices(EbsBlockDevice ... ebsBlockDevices) {
        if (this.ebsBlockDevices == null) {
            this.setEbsBlockDevices((Collection<EbsBlockDevice>)new SdkInternalList(ebsBlockDevices.length));
        }
        for (EbsBlockDevice ele : ebsBlockDevices) {
            this.ebsBlockDevices.add((Object)ele);
        }
        return this;
    }

    public InstanceTypeSpecification withEbsBlockDevices(Collection<EbsBlockDevice> ebsBlockDevices) {
        this.setEbsBlockDevices(ebsBlockDevices);
        return this;
    }

    public void setEbsOptimized(Boolean ebsOptimized) {
        this.ebsOptimized = ebsOptimized;
    }

    public Boolean getEbsOptimized() {
        return this.ebsOptimized;
    }

    public InstanceTypeSpecification withEbsOptimized(Boolean ebsOptimized) {
        this.setEbsOptimized(ebsOptimized);
        return this;
    }

    public Boolean isEbsOptimized() {
        return this.ebsOptimized;
    }

    public void setCustomAmiId(String customAmiId) {
        this.customAmiId = customAmiId;
    }

    public String getCustomAmiId() {
        return this.customAmiId;
    }

    public InstanceTypeSpecification withCustomAmiId(String customAmiId) {
        this.setCustomAmiId(customAmiId);
        return this;
    }

    public void setPriority(Double priority) {
        this.priority = priority;
    }

    public Double getPriority() {
        return this.priority;
    }

    public InstanceTypeSpecification withPriority(Double priority) {
        this.setPriority(priority);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getInstanceType() != null) {
            sb.append("InstanceType: ").append(this.getInstanceType()).append(",");
        }
        if (this.getWeightedCapacity() != null) {
            sb.append("WeightedCapacity: ").append(this.getWeightedCapacity()).append(",");
        }
        if (this.getBidPrice() != null) {
            sb.append("BidPrice: ").append(this.getBidPrice()).append(",");
        }
        if (this.getBidPriceAsPercentageOfOnDemandPrice() != null) {
            sb.append("BidPriceAsPercentageOfOnDemandPrice: ").append(this.getBidPriceAsPercentageOfOnDemandPrice()).append(",");
        }
        if (this.getConfigurations() != null) {
            sb.append("Configurations: ").append(this.getConfigurations()).append(",");
        }
        if (this.getEbsBlockDevices() != null) {
            sb.append("EbsBlockDevices: ").append(this.getEbsBlockDevices()).append(",");
        }
        if (this.getEbsOptimized() != null) {
            sb.append("EbsOptimized: ").append(this.getEbsOptimized()).append(",");
        }
        if (this.getCustomAmiId() != null) {
            sb.append("CustomAmiId: ").append(this.getCustomAmiId()).append(",");
        }
        if (this.getPriority() != null) {
            sb.append("Priority: ").append(this.getPriority());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InstanceTypeSpecification)) {
            return false;
        }
        InstanceTypeSpecification other = (InstanceTypeSpecification)obj;
        if (other.getInstanceType() == null ^ this.getInstanceType() == null) {
            return false;
        }
        if (other.getInstanceType() != null && !other.getInstanceType().equals(this.getInstanceType())) {
            return false;
        }
        if (other.getWeightedCapacity() == null ^ this.getWeightedCapacity() == null) {
            return false;
        }
        if (other.getWeightedCapacity() != null && !other.getWeightedCapacity().equals(this.getWeightedCapacity())) {
            return false;
        }
        if (other.getBidPrice() == null ^ this.getBidPrice() == null) {
            return false;
        }
        if (other.getBidPrice() != null && !other.getBidPrice().equals(this.getBidPrice())) {
            return false;
        }
        if (other.getBidPriceAsPercentageOfOnDemandPrice() == null ^ this.getBidPriceAsPercentageOfOnDemandPrice() == null) {
            return false;
        }
        if (other.getBidPriceAsPercentageOfOnDemandPrice() != null && !other.getBidPriceAsPercentageOfOnDemandPrice().equals(this.getBidPriceAsPercentageOfOnDemandPrice())) {
            return false;
        }
        if (other.getConfigurations() == null ^ this.getConfigurations() == null) {
            return false;
        }
        if (other.getConfigurations() != null && !other.getConfigurations().equals(this.getConfigurations())) {
            return false;
        }
        if (other.getEbsBlockDevices() == null ^ this.getEbsBlockDevices() == null) {
            return false;
        }
        if (other.getEbsBlockDevices() != null && !other.getEbsBlockDevices().equals(this.getEbsBlockDevices())) {
            return false;
        }
        if (other.getEbsOptimized() == null ^ this.getEbsOptimized() == null) {
            return false;
        }
        if (other.getEbsOptimized() != null && !other.getEbsOptimized().equals(this.getEbsOptimized())) {
            return false;
        }
        if (other.getCustomAmiId() == null ^ this.getCustomAmiId() == null) {
            return false;
        }
        if (other.getCustomAmiId() != null && !other.getCustomAmiId().equals(this.getCustomAmiId())) {
            return false;
        }
        if (other.getPriority() == null ^ this.getPriority() == null) {
            return false;
        }
        return other.getPriority() == null || other.getPriority().equals(this.getPriority());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getInstanceType() == null ? 0 : this.getInstanceType().hashCode());
        hashCode = 31 * hashCode + (this.getWeightedCapacity() == null ? 0 : this.getWeightedCapacity().hashCode());
        hashCode = 31 * hashCode + (this.getBidPrice() == null ? 0 : this.getBidPrice().hashCode());
        hashCode = 31 * hashCode + (this.getBidPriceAsPercentageOfOnDemandPrice() == null ? 0 : this.getBidPriceAsPercentageOfOnDemandPrice().hashCode());
        hashCode = 31 * hashCode + (this.getConfigurations() == null ? 0 : this.getConfigurations().hashCode());
        hashCode = 31 * hashCode + (this.getEbsBlockDevices() == null ? 0 : this.getEbsBlockDevices().hashCode());
        hashCode = 31 * hashCode + (this.getEbsOptimized() == null ? 0 : this.getEbsOptimized().hashCode());
        hashCode = 31 * hashCode + (this.getCustomAmiId() == null ? 0 : this.getCustomAmiId().hashCode());
        hashCode = 31 * hashCode + (this.getPriority() == null ? 0 : this.getPriority().hashCode());
        return hashCode;
    }

    public InstanceTypeSpecification clone() {
        try {
            return (InstanceTypeSpecification)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        InstanceTypeSpecificationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

