/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elastictranscoder.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.elastictranscoder.model.AudioParameters;

@SdkInternalApi
public class AudioParametersMarshaller {
    private static final MarshallingInfo<String> CODEC_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Codec").build();
    private static final MarshallingInfo<String> SAMPLERATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SampleRate").build();
    private static final MarshallingInfo<String> BITRATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("BitRate").build();
    private static final MarshallingInfo<String> CHANNELS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Channels").build();
    private static final MarshallingInfo<String> AUDIOPACKINGMODE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AudioPackingMode").build();
    private static final MarshallingInfo<StructuredPojo> CODECOPTIONS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CodecOptions").build();
    private static final AudioParametersMarshaller instance = new AudioParametersMarshaller();

    public static AudioParametersMarshaller getInstance() {
        return instance;
    }

    public void marshall(AudioParameters audioParameters, ProtocolMarshaller protocolMarshaller) {
        if (audioParameters == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)audioParameters.getCodec(), CODEC_BINDING);
            protocolMarshaller.marshall((Object)audioParameters.getSampleRate(), SAMPLERATE_BINDING);
            protocolMarshaller.marshall((Object)audioParameters.getBitRate(), BITRATE_BINDING);
            protocolMarshaller.marshall((Object)audioParameters.getChannels(), CHANNELS_BINDING);
            protocolMarshaller.marshall((Object)audioParameters.getAudioPackingMode(), AUDIOPACKINGMODE_BINDING);
            protocolMarshaller.marshall((Object)audioParameters.getCodecOptions(), CODECOPTIONS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

