/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticsearch.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.elasticsearch.model.UpgradeHistory;
import java.util.Date;
import java.util.List;

@SdkInternalApi
public class UpgradeHistoryMarshaller {
    private static final MarshallingInfo<String> UPGRADENAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("UpgradeName").build();
    private static final MarshallingInfo<Date> STARTTIMESTAMP_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("StartTimestamp").timestampFormat("unixTimestamp").build();
    private static final MarshallingInfo<String> UPGRADESTATUS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("UpgradeStatus").build();
    private static final MarshallingInfo<List> STEPSLIST_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("StepsList").build();
    private static final UpgradeHistoryMarshaller instance = new UpgradeHistoryMarshaller();

    public static UpgradeHistoryMarshaller getInstance() {
        return instance;
    }

    public void marshall(UpgradeHistory upgradeHistory, ProtocolMarshaller protocolMarshaller) {
        if (upgradeHistory == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)upgradeHistory.getUpgradeName(), UPGRADENAME_BINDING);
            protocolMarshaller.marshall((Object)upgradeHistory.getStartTimestamp(), STARTTIMESTAMP_BINDING);
            protocolMarshaller.marshall((Object)upgradeHistory.getUpgradeStatus(), UPGRADESTATUS_BINDING);
            protocolMarshaller.marshall(upgradeHistory.getStepsList(), STEPSLIST_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

