/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticsearch.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.services.elasticsearch.model.AdvancedOptionsStatus;
import com.amazonaws.services.elasticsearch.model.transform.OptionStatusJsonMarshaller;
import com.amazonaws.util.json.JSONWriter;
import java.util.Map;

public class AdvancedOptionsStatusJsonMarshaller {
    private static AdvancedOptionsStatusJsonMarshaller instance;

    public void marshall(AdvancedOptionsStatus advancedOptionsStatus, JSONWriter jsonWriter) {
        if (advancedOptionsStatus == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            jsonWriter.object();
            Map<String, String> optionsMap = advancedOptionsStatus.getOptions();
            if (optionsMap != null) {
                jsonWriter.key("Options");
                jsonWriter.object();
                for (Map.Entry<String, String> optionsMapValue : optionsMap.entrySet()) {
                    if (optionsMapValue.getValue() == null) continue;
                    jsonWriter.key(optionsMapValue.getKey());
                    jsonWriter.value((Object)optionsMapValue.getValue());
                }
                jsonWriter.endObject();
            }
            if (advancedOptionsStatus.getStatus() != null) {
                jsonWriter.key("Status");
                OptionStatusJsonMarshaller.getInstance().marshall(advancedOptionsStatus.getStatus(), jsonWriter);
            }
            jsonWriter.endObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static AdvancedOptionsStatusJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new AdvancedOptionsStatusJsonMarshaller();
        }
        return instance;
    }
}

