/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticloadbalancingv2.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.elasticloadbalancingv2.model.RemoveTrustStoreRevocationsRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.util.List;

public class RemoveTrustStoreRevocationsRequestMarshaller
implements Marshaller<Request<RemoveTrustStoreRevocationsRequest>, RemoveTrustStoreRevocationsRequest> {
    public Request<RemoveTrustStoreRevocationsRequest> marshall(RemoveTrustStoreRevocationsRequest removeTrustStoreRevocationsRequest) {
        if (removeTrustStoreRevocationsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)removeTrustStoreRevocationsRequest, "AmazonElasticLoadBalancing");
        request.addParameter("Action", "RemoveTrustStoreRevocations");
        request.addParameter("Version", "2015-12-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (removeTrustStoreRevocationsRequest.getTrustStoreArn() != null) {
            request.addParameter("TrustStoreArn", StringUtils.fromString((String)removeTrustStoreRevocationsRequest.getTrustStoreArn()));
        }
        if (removeTrustStoreRevocationsRequest.getRevocationIds() != null) {
            List<Long> revocationIdsList = removeTrustStoreRevocationsRequest.getRevocationIds();
            if (revocationIdsList.isEmpty()) {
                request.addParameter("RevocationIds", "");
            } else {
                int revocationIdsListIndex = 1;
                for (Long revocationIdsListValue : revocationIdsList) {
                    if (revocationIdsListValue != null) {
                        request.addParameter("RevocationIds.member." + revocationIdsListIndex, StringUtils.fromLong((Long)revocationIdsListValue));
                    }
                    ++revocationIdsListIndex;
                }
            }
        }
        return request;
    }
}

