/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticloadbalancingv2.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.elasticloadbalancingv2.model.DescribeTrustStoreRevocationsRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.util.List;

public class DescribeTrustStoreRevocationsRequestMarshaller
implements Marshaller<Request<DescribeTrustStoreRevocationsRequest>, DescribeTrustStoreRevocationsRequest> {
    public Request<DescribeTrustStoreRevocationsRequest> marshall(DescribeTrustStoreRevocationsRequest describeTrustStoreRevocationsRequest) {
        if (describeTrustStoreRevocationsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)describeTrustStoreRevocationsRequest, "AmazonElasticLoadBalancing");
        request.addParameter("Action", "DescribeTrustStoreRevocations");
        request.addParameter("Version", "2015-12-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (describeTrustStoreRevocationsRequest.getTrustStoreArn() != null) {
            request.addParameter("TrustStoreArn", StringUtils.fromString((String)describeTrustStoreRevocationsRequest.getTrustStoreArn()));
        }
        if (describeTrustStoreRevocationsRequest.getRevocationIds() != null) {
            List<Long> revocationIdsList = describeTrustStoreRevocationsRequest.getRevocationIds();
            if (revocationIdsList.isEmpty()) {
                request.addParameter("RevocationIds", "");
            } else {
                int revocationIdsListIndex = 1;
                for (Long revocationIdsListValue : revocationIdsList) {
                    if (revocationIdsListValue != null) {
                        request.addParameter("RevocationIds.member." + revocationIdsListIndex, StringUtils.fromLong((Long)revocationIdsListValue));
                    }
                    ++revocationIdsListIndex;
                }
            }
        }
        if (describeTrustStoreRevocationsRequest.getMarker() != null) {
            request.addParameter("Marker", StringUtils.fromString((String)describeTrustStoreRevocationsRequest.getMarker()));
        }
        if (describeTrustStoreRevocationsRequest.getPageSize() != null) {
            request.addParameter("PageSize", StringUtils.fromInteger((Integer)describeTrustStoreRevocationsRequest.getPageSize()));
        }
        return request;
    }
}

