/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticbeanstalk.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.elasticbeanstalk.model.Tag;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class ListTagsForResourceResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private String resourceArn;
    private SdkInternalList<Tag> resourceTags;

    public void setResourceArn(String resourceArn) {
        this.resourceArn = resourceArn;
    }

    public String getResourceArn() {
        return this.resourceArn;
    }

    public ListTagsForResourceResult withResourceArn(String resourceArn) {
        this.setResourceArn(resourceArn);
        return this;
    }

    public List<Tag> getResourceTags() {
        if (this.resourceTags == null) {
            this.resourceTags = new SdkInternalList();
        }
        return this.resourceTags;
    }

    public void setResourceTags(Collection<Tag> resourceTags) {
        if (resourceTags == null) {
            this.resourceTags = null;
            return;
        }
        this.resourceTags = new SdkInternalList(resourceTags);
    }

    public ListTagsForResourceResult withResourceTags(Tag ... resourceTags) {
        if (this.resourceTags == null) {
            this.setResourceTags((Collection<Tag>)new SdkInternalList(resourceTags.length));
        }
        for (Tag ele : resourceTags) {
            this.resourceTags.add((Object)ele);
        }
        return this;
    }

    public ListTagsForResourceResult withResourceTags(Collection<Tag> resourceTags) {
        this.setResourceTags(resourceTags);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getResourceArn() != null) {
            sb.append("ResourceArn: ").append(this.getResourceArn()).append(",");
        }
        if (this.getResourceTags() != null) {
            sb.append("ResourceTags: ").append(this.getResourceTags());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListTagsForResourceResult)) {
            return false;
        }
        ListTagsForResourceResult other = (ListTagsForResourceResult)obj;
        if (other.getResourceArn() == null ^ this.getResourceArn() == null) {
            return false;
        }
        if (other.getResourceArn() != null && !other.getResourceArn().equals(this.getResourceArn())) {
            return false;
        }
        if (other.getResourceTags() == null ^ this.getResourceTags() == null) {
            return false;
        }
        return other.getResourceTags() == null || other.getResourceTags().equals(this.getResourceTags());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getResourceArn() == null ? 0 : this.getResourceArn().hashCode());
        hashCode = 31 * hashCode + (this.getResourceTags() == null ? 0 : this.getResourceTags().hashCode());
        return hashCode;
    }

    public ListTagsForResourceResult clone() {
        try {
            return (ListTagsForResourceResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

