/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticbeanstalk.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.elasticbeanstalk.model.SearchFilter;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class ListPlatformBranchesRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private SdkInternalList<SearchFilter> filters;
    private Integer maxRecords;
    private String nextToken;

    public List<SearchFilter> getFilters() {
        if (this.filters == null) {
            this.filters = new SdkInternalList();
        }
        return this.filters;
    }

    public void setFilters(Collection<SearchFilter> filters) {
        if (filters == null) {
            this.filters = null;
            return;
        }
        this.filters = new SdkInternalList(filters);
    }

    public ListPlatformBranchesRequest withFilters(SearchFilter ... filters) {
        if (this.filters == null) {
            this.setFilters((Collection<SearchFilter>)new SdkInternalList(filters.length));
        }
        for (SearchFilter ele : filters) {
            this.filters.add((Object)ele);
        }
        return this;
    }

    public ListPlatformBranchesRequest withFilters(Collection<SearchFilter> filters) {
        this.setFilters(filters);
        return this;
    }

    public void setMaxRecords(Integer maxRecords) {
        this.maxRecords = maxRecords;
    }

    public Integer getMaxRecords() {
        return this.maxRecords;
    }

    public ListPlatformBranchesRequest withMaxRecords(Integer maxRecords) {
        this.setMaxRecords(maxRecords);
        return this;
    }

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public ListPlatformBranchesRequest withNextToken(String nextToken) {
        this.setNextToken(nextToken);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getFilters() != null) {
            sb.append("Filters: ").append(this.getFilters()).append(",");
        }
        if (this.getMaxRecords() != null) {
            sb.append("MaxRecords: ").append(this.getMaxRecords()).append(",");
        }
        if (this.getNextToken() != null) {
            sb.append("NextToken: ").append(this.getNextToken());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListPlatformBranchesRequest)) {
            return false;
        }
        ListPlatformBranchesRequest other = (ListPlatformBranchesRequest)obj;
        if (other.getFilters() == null ^ this.getFilters() == null) {
            return false;
        }
        if (other.getFilters() != null && !other.getFilters().equals(this.getFilters())) {
            return false;
        }
        if (other.getMaxRecords() == null ^ this.getMaxRecords() == null) {
            return false;
        }
        if (other.getMaxRecords() != null && !other.getMaxRecords().equals(this.getMaxRecords())) {
            return false;
        }
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        return other.getNextToken() == null || other.getNextToken().equals(this.getNextToken());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getFilters() == null ? 0 : this.getFilters().hashCode());
        hashCode = 31 * hashCode + (this.getMaxRecords() == null ? 0 : this.getMaxRecords().hashCode());
        hashCode = 31 * hashCode + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        return hashCode;
    }

    public ListPlatformBranchesRequest clone() {
        return (ListPlatformBranchesRequest)super.clone();
    }
}

