/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticbeanstalk.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.elasticbeanstalk.model.ConfigurationOptionSetting;
import com.amazonaws.services.elasticbeanstalk.model.EnvironmentTier;
import com.amazonaws.services.elasticbeanstalk.model.OptionSpecification;
import com.amazonaws.services.elasticbeanstalk.model.UpdateEnvironmentRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class UpdateEnvironmentRequestMarshaller
implements Marshaller<Request<UpdateEnvironmentRequest>, UpdateEnvironmentRequest> {
    public Request<UpdateEnvironmentRequest> marshall(UpdateEnvironmentRequest updateEnvironmentRequest) {
        SdkInternalList optionsToRemoveList;
        SdkInternalList optionSettingsList;
        EnvironmentTier tier;
        if (updateEnvironmentRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)updateEnvironmentRequest, "AWSElasticBeanstalk");
        request.addParameter("Action", "UpdateEnvironment");
        request.addParameter("Version", "2010-12-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (updateEnvironmentRequest.getApplicationName() != null) {
            request.addParameter("ApplicationName", StringUtils.fromString((String)updateEnvironmentRequest.getApplicationName()));
        }
        if (updateEnvironmentRequest.getEnvironmentId() != null) {
            request.addParameter("EnvironmentId", StringUtils.fromString((String)updateEnvironmentRequest.getEnvironmentId()));
        }
        if (updateEnvironmentRequest.getEnvironmentName() != null) {
            request.addParameter("EnvironmentName", StringUtils.fromString((String)updateEnvironmentRequest.getEnvironmentName()));
        }
        if (updateEnvironmentRequest.getGroupName() != null) {
            request.addParameter("GroupName", StringUtils.fromString((String)updateEnvironmentRequest.getGroupName()));
        }
        if (updateEnvironmentRequest.getDescription() != null) {
            request.addParameter("Description", StringUtils.fromString((String)updateEnvironmentRequest.getDescription()));
        }
        if ((tier = updateEnvironmentRequest.getTier()) != null) {
            if (tier.getName() != null) {
                request.addParameter("Tier.Name", StringUtils.fromString((String)tier.getName()));
            }
            if (tier.getType() != null) {
                request.addParameter("Tier.Type", StringUtils.fromString((String)tier.getType()));
            }
            if (tier.getVersion() != null) {
                request.addParameter("Tier.Version", StringUtils.fromString((String)tier.getVersion()));
            }
        }
        if (updateEnvironmentRequest.getVersionLabel() != null) {
            request.addParameter("VersionLabel", StringUtils.fromString((String)updateEnvironmentRequest.getVersionLabel()));
        }
        if (updateEnvironmentRequest.getTemplateName() != null) {
            request.addParameter("TemplateName", StringUtils.fromString((String)updateEnvironmentRequest.getTemplateName()));
        }
        if (updateEnvironmentRequest.getSolutionStackName() != null) {
            request.addParameter("SolutionStackName", StringUtils.fromString((String)updateEnvironmentRequest.getSolutionStackName()));
        }
        if (!(optionSettingsList = (SdkInternalList)updateEnvironmentRequest.getOptionSettings()).isEmpty() || !optionSettingsList.isAutoConstruct()) {
            int optionSettingsListIndex = 1;
            for (ConfigurationOptionSetting optionSettingsListValue : optionSettingsList) {
                if (optionSettingsListValue.getResourceName() != null) {
                    request.addParameter("OptionSettings.member." + optionSettingsListIndex + ".ResourceName", StringUtils.fromString((String)optionSettingsListValue.getResourceName()));
                }
                if (optionSettingsListValue.getNamespace() != null) {
                    request.addParameter("OptionSettings.member." + optionSettingsListIndex + ".Namespace", StringUtils.fromString((String)optionSettingsListValue.getNamespace()));
                }
                if (optionSettingsListValue.getOptionName() != null) {
                    request.addParameter("OptionSettings.member." + optionSettingsListIndex + ".OptionName", StringUtils.fromString((String)optionSettingsListValue.getOptionName()));
                }
                if (optionSettingsListValue.getValue() != null) {
                    request.addParameter("OptionSettings.member." + optionSettingsListIndex + ".Value", StringUtils.fromString((String)optionSettingsListValue.getValue()));
                }
                ++optionSettingsListIndex;
            }
        }
        if (!(optionsToRemoveList = (SdkInternalList)updateEnvironmentRequest.getOptionsToRemove()).isEmpty() || !optionsToRemoveList.isAutoConstruct()) {
            int optionsToRemoveListIndex = 1;
            for (OptionSpecification optionsToRemoveListValue : optionsToRemoveList) {
                if (optionsToRemoveListValue.getResourceName() != null) {
                    request.addParameter("OptionsToRemove.member." + optionsToRemoveListIndex + ".ResourceName", StringUtils.fromString((String)optionsToRemoveListValue.getResourceName()));
                }
                if (optionsToRemoveListValue.getNamespace() != null) {
                    request.addParameter("OptionsToRemove.member." + optionsToRemoveListIndex + ".Namespace", StringUtils.fromString((String)optionsToRemoveListValue.getNamespace()));
                }
                if (optionsToRemoveListValue.getOptionName() != null) {
                    request.addParameter("OptionsToRemove.member." + optionsToRemoveListIndex + ".OptionName", StringUtils.fromString((String)optionsToRemoveListValue.getOptionName()));
                }
                ++optionsToRemoveListIndex;
            }
        }
        return request;
    }
}

