/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticbeanstalk.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.elasticbeanstalk.model.CreateApplicationRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class CreateApplicationRequestMarshaller
implements Marshaller<Request<CreateApplicationRequest>, CreateApplicationRequest> {
    public Request<CreateApplicationRequest> marshall(CreateApplicationRequest createApplicationRequest) {
        if (createApplicationRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)createApplicationRequest, "AWSElasticBeanstalk");
        request.addParameter("Action", "CreateApplication");
        request.addParameter("Version", "2010-12-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (createApplicationRequest.getApplicationName() != null) {
            request.addParameter("ApplicationName", StringUtils.fromString((String)createApplicationRequest.getApplicationName()));
        }
        if (createApplicationRequest.getDescription() != null) {
            request.addParameter("Description", StringUtils.fromString((String)createApplicationRequest.getDescription()));
        }
        return request;
    }
}

