/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticache.model.transform;

import com.amazonaws.services.elasticache.model.NodeGroupConfiguration;
import com.amazonaws.transform.SimpleTypeStaxUnmarshallers;
import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import java.util.ArrayList;
import javax.xml.stream.events.XMLEvent;

public class NodeGroupConfigurationStaxUnmarshaller
implements Unmarshaller<NodeGroupConfiguration, StaxUnmarshallerContext> {
    private static NodeGroupConfigurationStaxUnmarshaller instance;

    public NodeGroupConfiguration unmarshall(StaxUnmarshallerContext context) throws Exception {
        NodeGroupConfiguration nodeGroupConfiguration = new NodeGroupConfiguration();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (true) {
            XMLEvent xmlEvent;
            if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                return nodeGroupConfiguration;
            }
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("NodeGroupId", targetDepth)) {
                    nodeGroupConfiguration.setNodeGroupId(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Slots", targetDepth)) {
                    nodeGroupConfiguration.setSlots(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("ReplicaCount", targetDepth)) {
                    nodeGroupConfiguration.setReplicaCount(SimpleTypeStaxUnmarshallers.IntegerStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("PrimaryAvailabilityZone", targetDepth)) {
                    nodeGroupConfiguration.setPrimaryAvailabilityZone(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("ReplicaAvailabilityZones", targetDepth)) {
                    nodeGroupConfiguration.withReplicaAvailabilityZones(new ArrayList<String>());
                    continue;
                }
                if (context.testExpression("ReplicaAvailabilityZones/AvailabilityZone", targetDepth)) {
                    nodeGroupConfiguration.withReplicaAvailabilityZones(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("PrimaryOutpostArn", targetDepth)) {
                    nodeGroupConfiguration.setPrimaryOutpostArn(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("ReplicaOutpostArns", targetDepth)) {
                    nodeGroupConfiguration.withReplicaOutpostArns(new ArrayList<String>());
                    continue;
                }
                if (!context.testExpression("ReplicaOutpostArns/OutpostArn", targetDepth)) continue;
                nodeGroupConfiguration.withReplicaOutpostArns(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
        }
        return nodeGroupConfiguration;
    }

    public static NodeGroupConfigurationStaxUnmarshaller getInstance() {
        if (instance == null) {
            instance = new NodeGroupConfigurationStaxUnmarshaller();
        }
        return instance;
    }
}

