/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticache.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.elasticache.model.Tag;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class CreateCacheParameterGroupRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String cacheParameterGroupName;
    private String cacheParameterGroupFamily;
    private String description;
    private SdkInternalList<Tag> tags;

    public CreateCacheParameterGroupRequest() {
    }

    public CreateCacheParameterGroupRequest(String cacheParameterGroupName, String cacheParameterGroupFamily, String description) {
        this.setCacheParameterGroupName(cacheParameterGroupName);
        this.setCacheParameterGroupFamily(cacheParameterGroupFamily);
        this.setDescription(description);
    }

    public void setCacheParameterGroupName(String cacheParameterGroupName) {
        this.cacheParameterGroupName = cacheParameterGroupName;
    }

    public String getCacheParameterGroupName() {
        return this.cacheParameterGroupName;
    }

    public CreateCacheParameterGroupRequest withCacheParameterGroupName(String cacheParameterGroupName) {
        this.setCacheParameterGroupName(cacheParameterGroupName);
        return this;
    }

    public void setCacheParameterGroupFamily(String cacheParameterGroupFamily) {
        this.cacheParameterGroupFamily = cacheParameterGroupFamily;
    }

    public String getCacheParameterGroupFamily() {
        return this.cacheParameterGroupFamily;
    }

    public CreateCacheParameterGroupRequest withCacheParameterGroupFamily(String cacheParameterGroupFamily) {
        this.setCacheParameterGroupFamily(cacheParameterGroupFamily);
        return this;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public CreateCacheParameterGroupRequest withDescription(String description) {
        this.setDescription(description);
        return this;
    }

    public List<Tag> getTags() {
        if (this.tags == null) {
            this.tags = new SdkInternalList();
        }
        return this.tags;
    }

    public void setTags(Collection<Tag> tags) {
        if (tags == null) {
            this.tags = null;
            return;
        }
        this.tags = new SdkInternalList(tags);
    }

    public CreateCacheParameterGroupRequest withTags(Tag ... tags) {
        if (this.tags == null) {
            this.setTags((Collection<Tag>)new SdkInternalList(tags.length));
        }
        for (Tag ele : tags) {
            this.tags.add((Object)ele);
        }
        return this;
    }

    public CreateCacheParameterGroupRequest withTags(Collection<Tag> tags) {
        this.setTags(tags);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getCacheParameterGroupName() != null) {
            sb.append("CacheParameterGroupName: ").append(this.getCacheParameterGroupName()).append(",");
        }
        if (this.getCacheParameterGroupFamily() != null) {
            sb.append("CacheParameterGroupFamily: ").append(this.getCacheParameterGroupFamily()).append(",");
        }
        if (this.getDescription() != null) {
            sb.append("Description: ").append(this.getDescription()).append(",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: ").append(this.getTags());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateCacheParameterGroupRequest)) {
            return false;
        }
        CreateCacheParameterGroupRequest other = (CreateCacheParameterGroupRequest)obj;
        if (other.getCacheParameterGroupName() == null ^ this.getCacheParameterGroupName() == null) {
            return false;
        }
        if (other.getCacheParameterGroupName() != null && !other.getCacheParameterGroupName().equals(this.getCacheParameterGroupName())) {
            return false;
        }
        if (other.getCacheParameterGroupFamily() == null ^ this.getCacheParameterGroupFamily() == null) {
            return false;
        }
        if (other.getCacheParameterGroupFamily() != null && !other.getCacheParameterGroupFamily().equals(this.getCacheParameterGroupFamily())) {
            return false;
        }
        if (other.getDescription() == null ^ this.getDescription() == null) {
            return false;
        }
        if (other.getDescription() != null && !other.getDescription().equals(this.getDescription())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        return other.getTags() == null || other.getTags().equals(this.getTags());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getCacheParameterGroupName() == null ? 0 : this.getCacheParameterGroupName().hashCode());
        hashCode = 31 * hashCode + (this.getCacheParameterGroupFamily() == null ? 0 : this.getCacheParameterGroupFamily().hashCode());
        hashCode = 31 * hashCode + (this.getDescription() == null ? 0 : this.getDescription().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        return hashCode;
    }

    public CreateCacheParameterGroupRequest clone() {
        return (CreateCacheParameterGroupRequest)super.clone();
    }
}

