/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticache.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.elasticache.model.CreateUserRequest;
import com.amazonaws.services.elasticache.model.Tag;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class CreateUserRequestMarshaller
implements Marshaller<Request<CreateUserRequest>, CreateUserRequest> {
    public Request<CreateUserRequest> marshall(CreateUserRequest createUserRequest) {
        if (createUserRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)createUserRequest, "AmazonElastiCache");
        request.addParameter("Action", "CreateUser");
        request.addParameter("Version", "2015-02-02");
        request.setHttpMethod(HttpMethodName.POST);
        if (createUserRequest.getUserId() != null) {
            request.addParameter("UserId", StringUtils.fromString((String)createUserRequest.getUserId()));
        }
        if (createUserRequest.getUserName() != null) {
            request.addParameter("UserName", StringUtils.fromString((String)createUserRequest.getUserName()));
        }
        if (createUserRequest.getEngine() != null) {
            request.addParameter("Engine", StringUtils.fromString((String)createUserRequest.getEngine()));
        }
        if (!createUserRequest.getPasswords().isEmpty() || !((SdkInternalList)createUserRequest.getPasswords()).isAutoConstruct()) {
            SdkInternalList passwordsList = (SdkInternalList)createUserRequest.getPasswords();
            int passwordsListIndex = 1;
            for (String passwordsListValue : passwordsList) {
                if (passwordsListValue != null) {
                    request.addParameter("Passwords.member." + passwordsListIndex, StringUtils.fromString((String)passwordsListValue));
                }
                ++passwordsListIndex;
            }
        }
        if (createUserRequest.getAccessString() != null) {
            request.addParameter("AccessString", StringUtils.fromString((String)createUserRequest.getAccessString()));
        }
        if (createUserRequest.getNoPasswordRequired() != null) {
            request.addParameter("NoPasswordRequired", StringUtils.fromBoolean((Boolean)createUserRequest.getNoPasswordRequired()));
        }
        if (!createUserRequest.getTags().isEmpty() || !((SdkInternalList)createUserRequest.getTags()).isAutoConstruct()) {
            SdkInternalList tagsList = (SdkInternalList)createUserRequest.getTags();
            int tagsListIndex = 1;
            for (Tag tagsListValue : tagsList) {
                if (tagsListValue != null) {
                    if (tagsListValue.getKey() != null) {
                        request.addParameter("Tags.Tag." + tagsListIndex + ".Key", StringUtils.fromString((String)tagsListValue.getKey()));
                    }
                    if (tagsListValue.getValue() != null) {
                        request.addParameter("Tags.Tag." + tagsListIndex + ".Value", StringUtils.fromString((String)tagsListValue.getValue()));
                    }
                }
                ++tagsListIndex;
            }
        }
        return request;
    }
}

