/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.eks.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.eks.model.ClusterHealth;
import java.util.List;

@SdkInternalApi
public class ClusterHealthMarshaller {
    private static final MarshallingInfo<List> ISSUES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("issues").build();
    private static final ClusterHealthMarshaller instance = new ClusterHealthMarshaller();

    public static ClusterHealthMarshaller getInstance() {
        return instance;
    }

    public void marshall(ClusterHealth clusterHealth, ProtocolMarshaller protocolMarshaller) {
        if (clusterHealth == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(clusterHealth.getIssues(), ISSUES_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

