/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticfilesystem.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.elasticfilesystem.model.LifecyclePolicy;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class PutLifecycleConfigurationRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String fileSystemId;
    private SdkInternalList<LifecyclePolicy> lifecyclePolicies;

    public void setFileSystemId(String fileSystemId) {
        this.fileSystemId = fileSystemId;
    }

    public String getFileSystemId() {
        return this.fileSystemId;
    }

    public PutLifecycleConfigurationRequest withFileSystemId(String fileSystemId) {
        this.setFileSystemId(fileSystemId);
        return this;
    }

    public List<LifecyclePolicy> getLifecyclePolicies() {
        if (this.lifecyclePolicies == null) {
            this.lifecyclePolicies = new SdkInternalList();
        }
        return this.lifecyclePolicies;
    }

    public void setLifecyclePolicies(Collection<LifecyclePolicy> lifecyclePolicies) {
        if (lifecyclePolicies == null) {
            this.lifecyclePolicies = null;
            return;
        }
        this.lifecyclePolicies = new SdkInternalList(lifecyclePolicies);
    }

    public PutLifecycleConfigurationRequest withLifecyclePolicies(LifecyclePolicy ... lifecyclePolicies) {
        if (this.lifecyclePolicies == null) {
            this.setLifecyclePolicies((Collection<LifecyclePolicy>)new SdkInternalList(lifecyclePolicies.length));
        }
        for (LifecyclePolicy ele : lifecyclePolicies) {
            this.lifecyclePolicies.add((Object)ele);
        }
        return this;
    }

    public PutLifecycleConfigurationRequest withLifecyclePolicies(Collection<LifecyclePolicy> lifecyclePolicies) {
        this.setLifecyclePolicies(lifecyclePolicies);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getFileSystemId() != null) {
            sb.append("FileSystemId: ").append(this.getFileSystemId()).append(",");
        }
        if (this.getLifecyclePolicies() != null) {
            sb.append("LifecyclePolicies: ").append(this.getLifecyclePolicies());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutLifecycleConfigurationRequest)) {
            return false;
        }
        PutLifecycleConfigurationRequest other = (PutLifecycleConfigurationRequest)obj;
        if (other.getFileSystemId() == null ^ this.getFileSystemId() == null) {
            return false;
        }
        if (other.getFileSystemId() != null && !other.getFileSystemId().equals(this.getFileSystemId())) {
            return false;
        }
        if (other.getLifecyclePolicies() == null ^ this.getLifecyclePolicies() == null) {
            return false;
        }
        return other.getLifecyclePolicies() == null || other.getLifecyclePolicies().equals(this.getLifecyclePolicies());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getFileSystemId() == null ? 0 : this.getFileSystemId().hashCode());
        hashCode = 31 * hashCode + (this.getLifecyclePolicies() == null ? 0 : this.getLifecyclePolicies().hashCode());
        return hashCode;
    }

    public PutLifecycleConfigurationRequest clone() {
        return (PutLifecycleConfigurationRequest)super.clone();
    }
}

