/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticfilesystem.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.elasticfilesystem.model.LifeCycleState;
import com.amazonaws.services.elasticfilesystem.model.PosixUser;
import com.amazonaws.services.elasticfilesystem.model.RootDirectory;
import com.amazonaws.services.elasticfilesystem.model.Tag;
import com.amazonaws.services.elasticfilesystem.model.transform.AccessPointDescriptionMarshaller;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class AccessPointDescription
implements Serializable,
Cloneable,
StructuredPojo {
    private String clientToken;
    private String name;
    private SdkInternalList<Tag> tags;
    private String accessPointId;
    private String accessPointArn;
    private String fileSystemId;
    private PosixUser posixUser;
    private RootDirectory rootDirectory;
    private String ownerId;
    private String lifeCycleState;

    public void setClientToken(String clientToken) {
        this.clientToken = clientToken;
    }

    public String getClientToken() {
        return this.clientToken;
    }

    public AccessPointDescription withClientToken(String clientToken) {
        this.setClientToken(clientToken);
        return this;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public AccessPointDescription withName(String name) {
        this.setName(name);
        return this;
    }

    public List<Tag> getTags() {
        if (this.tags == null) {
            this.tags = new SdkInternalList();
        }
        return this.tags;
    }

    public void setTags(Collection<Tag> tags) {
        if (tags == null) {
            this.tags = null;
            return;
        }
        this.tags = new SdkInternalList(tags);
    }

    public AccessPointDescription withTags(Tag ... tags) {
        if (this.tags == null) {
            this.setTags((Collection<Tag>)new SdkInternalList(tags.length));
        }
        for (Tag ele : tags) {
            this.tags.add((Object)ele);
        }
        return this;
    }

    public AccessPointDescription withTags(Collection<Tag> tags) {
        this.setTags(tags);
        return this;
    }

    public void setAccessPointId(String accessPointId) {
        this.accessPointId = accessPointId;
    }

    public String getAccessPointId() {
        return this.accessPointId;
    }

    public AccessPointDescription withAccessPointId(String accessPointId) {
        this.setAccessPointId(accessPointId);
        return this;
    }

    public void setAccessPointArn(String accessPointArn) {
        this.accessPointArn = accessPointArn;
    }

    public String getAccessPointArn() {
        return this.accessPointArn;
    }

    public AccessPointDescription withAccessPointArn(String accessPointArn) {
        this.setAccessPointArn(accessPointArn);
        return this;
    }

    public void setFileSystemId(String fileSystemId) {
        this.fileSystemId = fileSystemId;
    }

    public String getFileSystemId() {
        return this.fileSystemId;
    }

    public AccessPointDescription withFileSystemId(String fileSystemId) {
        this.setFileSystemId(fileSystemId);
        return this;
    }

    public void setPosixUser(PosixUser posixUser) {
        this.posixUser = posixUser;
    }

    public PosixUser getPosixUser() {
        return this.posixUser;
    }

    public AccessPointDescription withPosixUser(PosixUser posixUser) {
        this.setPosixUser(posixUser);
        return this;
    }

    public void setRootDirectory(RootDirectory rootDirectory) {
        this.rootDirectory = rootDirectory;
    }

    public RootDirectory getRootDirectory() {
        return this.rootDirectory;
    }

    public AccessPointDescription withRootDirectory(RootDirectory rootDirectory) {
        this.setRootDirectory(rootDirectory);
        return this;
    }

    public void setOwnerId(String ownerId) {
        this.ownerId = ownerId;
    }

    public String getOwnerId() {
        return this.ownerId;
    }

    public AccessPointDescription withOwnerId(String ownerId) {
        this.setOwnerId(ownerId);
        return this;
    }

    public void setLifeCycleState(String lifeCycleState) {
        this.lifeCycleState = lifeCycleState;
    }

    public String getLifeCycleState() {
        return this.lifeCycleState;
    }

    public AccessPointDescription withLifeCycleState(String lifeCycleState) {
        this.setLifeCycleState(lifeCycleState);
        return this;
    }

    public AccessPointDescription withLifeCycleState(LifeCycleState lifeCycleState) {
        this.lifeCycleState = lifeCycleState.toString();
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getClientToken() != null) {
            sb.append("ClientToken: ").append(this.getClientToken()).append(",");
        }
        if (this.getName() != null) {
            sb.append("Name: ").append(this.getName()).append(",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: ").append(this.getTags()).append(",");
        }
        if (this.getAccessPointId() != null) {
            sb.append("AccessPointId: ").append(this.getAccessPointId()).append(",");
        }
        if (this.getAccessPointArn() != null) {
            sb.append("AccessPointArn: ").append(this.getAccessPointArn()).append(",");
        }
        if (this.getFileSystemId() != null) {
            sb.append("FileSystemId: ").append(this.getFileSystemId()).append(",");
        }
        if (this.getPosixUser() != null) {
            sb.append("PosixUser: ").append(this.getPosixUser()).append(",");
        }
        if (this.getRootDirectory() != null) {
            sb.append("RootDirectory: ").append(this.getRootDirectory()).append(",");
        }
        if (this.getOwnerId() != null) {
            sb.append("OwnerId: ").append(this.getOwnerId()).append(",");
        }
        if (this.getLifeCycleState() != null) {
            sb.append("LifeCycleState: ").append(this.getLifeCycleState());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AccessPointDescription)) {
            return false;
        }
        AccessPointDescription other = (AccessPointDescription)obj;
        if (other.getClientToken() == null ^ this.getClientToken() == null) {
            return false;
        }
        if (other.getClientToken() != null && !other.getClientToken().equals(this.getClientToken())) {
            return false;
        }
        if (other.getName() == null ^ this.getName() == null) {
            return false;
        }
        if (other.getName() != null && !other.getName().equals(this.getName())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        if (other.getTags() != null && !other.getTags().equals(this.getTags())) {
            return false;
        }
        if (other.getAccessPointId() == null ^ this.getAccessPointId() == null) {
            return false;
        }
        if (other.getAccessPointId() != null && !other.getAccessPointId().equals(this.getAccessPointId())) {
            return false;
        }
        if (other.getAccessPointArn() == null ^ this.getAccessPointArn() == null) {
            return false;
        }
        if (other.getAccessPointArn() != null && !other.getAccessPointArn().equals(this.getAccessPointArn())) {
            return false;
        }
        if (other.getFileSystemId() == null ^ this.getFileSystemId() == null) {
            return false;
        }
        if (other.getFileSystemId() != null && !other.getFileSystemId().equals(this.getFileSystemId())) {
            return false;
        }
        if (other.getPosixUser() == null ^ this.getPosixUser() == null) {
            return false;
        }
        if (other.getPosixUser() != null && !other.getPosixUser().equals(this.getPosixUser())) {
            return false;
        }
        if (other.getRootDirectory() == null ^ this.getRootDirectory() == null) {
            return false;
        }
        if (other.getRootDirectory() != null && !other.getRootDirectory().equals(this.getRootDirectory())) {
            return false;
        }
        if (other.getOwnerId() == null ^ this.getOwnerId() == null) {
            return false;
        }
        if (other.getOwnerId() != null && !other.getOwnerId().equals(this.getOwnerId())) {
            return false;
        }
        if (other.getLifeCycleState() == null ^ this.getLifeCycleState() == null) {
            return false;
        }
        return other.getLifeCycleState() == null || other.getLifeCycleState().equals(this.getLifeCycleState());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getClientToken() == null ? 0 : this.getClientToken().hashCode());
        hashCode = 31 * hashCode + (this.getName() == null ? 0 : this.getName().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        hashCode = 31 * hashCode + (this.getAccessPointId() == null ? 0 : this.getAccessPointId().hashCode());
        hashCode = 31 * hashCode + (this.getAccessPointArn() == null ? 0 : this.getAccessPointArn().hashCode());
        hashCode = 31 * hashCode + (this.getFileSystemId() == null ? 0 : this.getFileSystemId().hashCode());
        hashCode = 31 * hashCode + (this.getPosixUser() == null ? 0 : this.getPosixUser().hashCode());
        hashCode = 31 * hashCode + (this.getRootDirectory() == null ? 0 : this.getRootDirectory().hashCode());
        hashCode = 31 * hashCode + (this.getOwnerId() == null ? 0 : this.getOwnerId().hashCode());
        hashCode = 31 * hashCode + (this.getLifeCycleState() == null ? 0 : this.getLifeCycleState().hashCode());
        return hashCode;
    }

    public AccessPointDescription clone() {
        try {
            return (AccessPointDescription)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        AccessPointDescriptionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

