/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ecs.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.ecs.model.AttachmentStateChange;
import com.amazonaws.services.ecs.model.ContainerStateChange;
import com.amazonaws.services.ecs.model.ManagedAgentStateChange;
import java.io.Serializable;
import java.util.Collection;
import java.util.Date;
import java.util.List;

public class SubmitTaskStateChangeRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String cluster;
    private String task;
    private String status;
    private String reason;
    private SdkInternalList<ContainerStateChange> containers;
    private SdkInternalList<AttachmentStateChange> attachments;
    private SdkInternalList<ManagedAgentStateChange> managedAgents;
    private Date pullStartedAt;
    private Date pullStoppedAt;
    private Date executionStoppedAt;

    public void setCluster(String cluster) {
        this.cluster = cluster;
    }

    public String getCluster() {
        return this.cluster;
    }

    public SubmitTaskStateChangeRequest withCluster(String cluster) {
        this.setCluster(cluster);
        return this;
    }

    public void setTask(String task) {
        this.task = task;
    }

    public String getTask() {
        return this.task;
    }

    public SubmitTaskStateChangeRequest withTask(String task) {
        this.setTask(task);
        return this;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getStatus() {
        return this.status;
    }

    public SubmitTaskStateChangeRequest withStatus(String status) {
        this.setStatus(status);
        return this;
    }

    public void setReason(String reason) {
        this.reason = reason;
    }

    public String getReason() {
        return this.reason;
    }

    public SubmitTaskStateChangeRequest withReason(String reason) {
        this.setReason(reason);
        return this;
    }

    public List<ContainerStateChange> getContainers() {
        if (this.containers == null) {
            this.containers = new SdkInternalList();
        }
        return this.containers;
    }

    public void setContainers(Collection<ContainerStateChange> containers) {
        if (containers == null) {
            this.containers = null;
            return;
        }
        this.containers = new SdkInternalList(containers);
    }

    public SubmitTaskStateChangeRequest withContainers(ContainerStateChange ... containers) {
        if (this.containers == null) {
            this.setContainers((Collection<ContainerStateChange>)new SdkInternalList(containers.length));
        }
        for (ContainerStateChange ele : containers) {
            this.containers.add((Object)ele);
        }
        return this;
    }

    public SubmitTaskStateChangeRequest withContainers(Collection<ContainerStateChange> containers) {
        this.setContainers(containers);
        return this;
    }

    public List<AttachmentStateChange> getAttachments() {
        if (this.attachments == null) {
            this.attachments = new SdkInternalList();
        }
        return this.attachments;
    }

    public void setAttachments(Collection<AttachmentStateChange> attachments) {
        if (attachments == null) {
            this.attachments = null;
            return;
        }
        this.attachments = new SdkInternalList(attachments);
    }

    public SubmitTaskStateChangeRequest withAttachments(AttachmentStateChange ... attachments) {
        if (this.attachments == null) {
            this.setAttachments((Collection<AttachmentStateChange>)new SdkInternalList(attachments.length));
        }
        for (AttachmentStateChange ele : attachments) {
            this.attachments.add((Object)ele);
        }
        return this;
    }

    public SubmitTaskStateChangeRequest withAttachments(Collection<AttachmentStateChange> attachments) {
        this.setAttachments(attachments);
        return this;
    }

    public List<ManagedAgentStateChange> getManagedAgents() {
        if (this.managedAgents == null) {
            this.managedAgents = new SdkInternalList();
        }
        return this.managedAgents;
    }

    public void setManagedAgents(Collection<ManagedAgentStateChange> managedAgents) {
        if (managedAgents == null) {
            this.managedAgents = null;
            return;
        }
        this.managedAgents = new SdkInternalList(managedAgents);
    }

    public SubmitTaskStateChangeRequest withManagedAgents(ManagedAgentStateChange ... managedAgents) {
        if (this.managedAgents == null) {
            this.setManagedAgents((Collection<ManagedAgentStateChange>)new SdkInternalList(managedAgents.length));
        }
        for (ManagedAgentStateChange ele : managedAgents) {
            this.managedAgents.add((Object)ele);
        }
        return this;
    }

    public SubmitTaskStateChangeRequest withManagedAgents(Collection<ManagedAgentStateChange> managedAgents) {
        this.setManagedAgents(managedAgents);
        return this;
    }

    public void setPullStartedAt(Date pullStartedAt) {
        this.pullStartedAt = pullStartedAt;
    }

    public Date getPullStartedAt() {
        return this.pullStartedAt;
    }

    public SubmitTaskStateChangeRequest withPullStartedAt(Date pullStartedAt) {
        this.setPullStartedAt(pullStartedAt);
        return this;
    }

    public void setPullStoppedAt(Date pullStoppedAt) {
        this.pullStoppedAt = pullStoppedAt;
    }

    public Date getPullStoppedAt() {
        return this.pullStoppedAt;
    }

    public SubmitTaskStateChangeRequest withPullStoppedAt(Date pullStoppedAt) {
        this.setPullStoppedAt(pullStoppedAt);
        return this;
    }

    public void setExecutionStoppedAt(Date executionStoppedAt) {
        this.executionStoppedAt = executionStoppedAt;
    }

    public Date getExecutionStoppedAt() {
        return this.executionStoppedAt;
    }

    public SubmitTaskStateChangeRequest withExecutionStoppedAt(Date executionStoppedAt) {
        this.setExecutionStoppedAt(executionStoppedAt);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getCluster() != null) {
            sb.append("Cluster: ").append(this.getCluster()).append(",");
        }
        if (this.getTask() != null) {
            sb.append("Task: ").append(this.getTask()).append(",");
        }
        if (this.getStatus() != null) {
            sb.append("Status: ").append(this.getStatus()).append(",");
        }
        if (this.getReason() != null) {
            sb.append("Reason: ").append(this.getReason()).append(",");
        }
        if (this.getContainers() != null) {
            sb.append("Containers: ").append(this.getContainers()).append(",");
        }
        if (this.getAttachments() != null) {
            sb.append("Attachments: ").append(this.getAttachments()).append(",");
        }
        if (this.getManagedAgents() != null) {
            sb.append("ManagedAgents: ").append(this.getManagedAgents()).append(",");
        }
        if (this.getPullStartedAt() != null) {
            sb.append("PullStartedAt: ").append(this.getPullStartedAt()).append(",");
        }
        if (this.getPullStoppedAt() != null) {
            sb.append("PullStoppedAt: ").append(this.getPullStoppedAt()).append(",");
        }
        if (this.getExecutionStoppedAt() != null) {
            sb.append("ExecutionStoppedAt: ").append(this.getExecutionStoppedAt());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SubmitTaskStateChangeRequest)) {
            return false;
        }
        SubmitTaskStateChangeRequest other = (SubmitTaskStateChangeRequest)obj;
        if (other.getCluster() == null ^ this.getCluster() == null) {
            return false;
        }
        if (other.getCluster() != null && !other.getCluster().equals(this.getCluster())) {
            return false;
        }
        if (other.getTask() == null ^ this.getTask() == null) {
            return false;
        }
        if (other.getTask() != null && !other.getTask().equals(this.getTask())) {
            return false;
        }
        if (other.getStatus() == null ^ this.getStatus() == null) {
            return false;
        }
        if (other.getStatus() != null && !other.getStatus().equals(this.getStatus())) {
            return false;
        }
        if (other.getReason() == null ^ this.getReason() == null) {
            return false;
        }
        if (other.getReason() != null && !other.getReason().equals(this.getReason())) {
            return false;
        }
        if (other.getContainers() == null ^ this.getContainers() == null) {
            return false;
        }
        if (other.getContainers() != null && !other.getContainers().equals(this.getContainers())) {
            return false;
        }
        if (other.getAttachments() == null ^ this.getAttachments() == null) {
            return false;
        }
        if (other.getAttachments() != null && !other.getAttachments().equals(this.getAttachments())) {
            return false;
        }
        if (other.getManagedAgents() == null ^ this.getManagedAgents() == null) {
            return false;
        }
        if (other.getManagedAgents() != null && !other.getManagedAgents().equals(this.getManagedAgents())) {
            return false;
        }
        if (other.getPullStartedAt() == null ^ this.getPullStartedAt() == null) {
            return false;
        }
        if (other.getPullStartedAt() != null && !other.getPullStartedAt().equals(this.getPullStartedAt())) {
            return false;
        }
        if (other.getPullStoppedAt() == null ^ this.getPullStoppedAt() == null) {
            return false;
        }
        if (other.getPullStoppedAt() != null && !other.getPullStoppedAt().equals(this.getPullStoppedAt())) {
            return false;
        }
        if (other.getExecutionStoppedAt() == null ^ this.getExecutionStoppedAt() == null) {
            return false;
        }
        return other.getExecutionStoppedAt() == null || other.getExecutionStoppedAt().equals(this.getExecutionStoppedAt());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getCluster() == null ? 0 : this.getCluster().hashCode());
        hashCode = 31 * hashCode + (this.getTask() == null ? 0 : this.getTask().hashCode());
        hashCode = 31 * hashCode + (this.getStatus() == null ? 0 : this.getStatus().hashCode());
        hashCode = 31 * hashCode + (this.getReason() == null ? 0 : this.getReason().hashCode());
        hashCode = 31 * hashCode + (this.getContainers() == null ? 0 : this.getContainers().hashCode());
        hashCode = 31 * hashCode + (this.getAttachments() == null ? 0 : this.getAttachments().hashCode());
        hashCode = 31 * hashCode + (this.getManagedAgents() == null ? 0 : this.getManagedAgents().hashCode());
        hashCode = 31 * hashCode + (this.getPullStartedAt() == null ? 0 : this.getPullStartedAt().hashCode());
        hashCode = 31 * hashCode + (this.getPullStoppedAt() == null ? 0 : this.getPullStoppedAt().hashCode());
        hashCode = 31 * hashCode + (this.getExecutionStoppedAt() == null ? 0 : this.getExecutionStoppedAt().hashCode());
        return hashCode;
    }

    public SubmitTaskStateChangeRequest clone() {
        return (SubmitTaskStateChangeRequest)super.clone();
    }
}

