/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ecs.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.ecs.model.EBSResourceType;
import com.amazonaws.services.ecs.model.PropagateTags;
import com.amazonaws.services.ecs.model.Tag;
import com.amazonaws.services.ecs.model.transform.EBSTagSpecificationMarshaller;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class EBSTagSpecification
implements Serializable,
Cloneable,
StructuredPojo {
    private String resourceType;
    private SdkInternalList<Tag> tags;
    private String propagateTags;

    public void setResourceType(String resourceType) {
        this.resourceType = resourceType;
    }

    public String getResourceType() {
        return this.resourceType;
    }

    public EBSTagSpecification withResourceType(String resourceType) {
        this.setResourceType(resourceType);
        return this;
    }

    public EBSTagSpecification withResourceType(EBSResourceType resourceType) {
        this.resourceType = resourceType.toString();
        return this;
    }

    public List<Tag> getTags() {
        if (this.tags == null) {
            this.tags = new SdkInternalList();
        }
        return this.tags;
    }

    public void setTags(Collection<Tag> tags) {
        if (tags == null) {
            this.tags = null;
            return;
        }
        this.tags = new SdkInternalList(tags);
    }

    public EBSTagSpecification withTags(Tag ... tags) {
        if (this.tags == null) {
            this.setTags((Collection<Tag>)new SdkInternalList(tags.length));
        }
        for (Tag ele : tags) {
            this.tags.add((Object)ele);
        }
        return this;
    }

    public EBSTagSpecification withTags(Collection<Tag> tags) {
        this.setTags(tags);
        return this;
    }

    public void setPropagateTags(String propagateTags) {
        this.propagateTags = propagateTags;
    }

    public String getPropagateTags() {
        return this.propagateTags;
    }

    public EBSTagSpecification withPropagateTags(String propagateTags) {
        this.setPropagateTags(propagateTags);
        return this;
    }

    public EBSTagSpecification withPropagateTags(PropagateTags propagateTags) {
        this.propagateTags = propagateTags.toString();
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getResourceType() != null) {
            sb.append("ResourceType: ").append(this.getResourceType()).append(",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: ").append(this.getTags()).append(",");
        }
        if (this.getPropagateTags() != null) {
            sb.append("PropagateTags: ").append(this.getPropagateTags());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EBSTagSpecification)) {
            return false;
        }
        EBSTagSpecification other = (EBSTagSpecification)obj;
        if (other.getResourceType() == null ^ this.getResourceType() == null) {
            return false;
        }
        if (other.getResourceType() != null && !other.getResourceType().equals(this.getResourceType())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        if (other.getTags() != null && !other.getTags().equals(this.getTags())) {
            return false;
        }
        if (other.getPropagateTags() == null ^ this.getPropagateTags() == null) {
            return false;
        }
        return other.getPropagateTags() == null || other.getPropagateTags().equals(this.getPropagateTags());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getResourceType() == null ? 0 : this.getResourceType().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        hashCode = 31 * hashCode + (this.getPropagateTags() == null ? 0 : this.getPropagateTags().hashCode());
        return hashCode;
    }

    public EBSTagSpecification clone() {
        try {
            return (EBSTagSpecification)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        EBSTagSpecificationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

