/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ecr.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.ecr.model.PackageVulnerabilityDetails;
import java.util.Date;
import java.util.List;

@SdkInternalApi
public class PackageVulnerabilityDetailsMarshaller {
    private static final MarshallingInfo<List> CVSS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("cvss").build();
    private static final MarshallingInfo<List> REFERENCEURLS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("referenceUrls").build();
    private static final MarshallingInfo<List> RELATEDVULNERABILITIES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("relatedVulnerabilities").build();
    private static final MarshallingInfo<String> SOURCE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("source").build();
    private static final MarshallingInfo<String> SOURCEURL_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("sourceUrl").build();
    private static final MarshallingInfo<Date> VENDORCREATEDAT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("vendorCreatedAt").timestampFormat("unixTimestamp").build();
    private static final MarshallingInfo<String> VENDORSEVERITY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("vendorSeverity").build();
    private static final MarshallingInfo<Date> VENDORUPDATEDAT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("vendorUpdatedAt").timestampFormat("unixTimestamp").build();
    private static final MarshallingInfo<String> VULNERABILITYID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("vulnerabilityId").build();
    private static final MarshallingInfo<List> VULNERABLEPACKAGES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("vulnerablePackages").build();
    private static final PackageVulnerabilityDetailsMarshaller instance = new PackageVulnerabilityDetailsMarshaller();

    public static PackageVulnerabilityDetailsMarshaller getInstance() {
        return instance;
    }

    public void marshall(PackageVulnerabilityDetails packageVulnerabilityDetails, ProtocolMarshaller protocolMarshaller) {
        if (packageVulnerabilityDetails == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(packageVulnerabilityDetails.getCvss(), CVSS_BINDING);
            protocolMarshaller.marshall(packageVulnerabilityDetails.getReferenceUrls(), REFERENCEURLS_BINDING);
            protocolMarshaller.marshall(packageVulnerabilityDetails.getRelatedVulnerabilities(), RELATEDVULNERABILITIES_BINDING);
            protocolMarshaller.marshall((Object)packageVulnerabilityDetails.getSource(), SOURCE_BINDING);
            protocolMarshaller.marshall((Object)packageVulnerabilityDetails.getSourceUrl(), SOURCEURL_BINDING);
            protocolMarshaller.marshall((Object)packageVulnerabilityDetails.getVendorCreatedAt(), VENDORCREATEDAT_BINDING);
            protocolMarshaller.marshall((Object)packageVulnerabilityDetails.getVendorSeverity(), VENDORSEVERITY_BINDING);
            protocolMarshaller.marshall((Object)packageVulnerabilityDetails.getVendorUpdatedAt(), VENDORUPDATEDAT_BINDING);
            protocolMarshaller.marshall((Object)packageVulnerabilityDetails.getVulnerabilityId(), VULNERABILITYID_BINDING);
            protocolMarshaller.marshall(packageVulnerabilityDetails.getVulnerablePackages(), VULNERABLEPACKAGES_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

