/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.services.ec2.model.Ipam;
import com.amazonaws.services.ec2.model.IpamOperatingRegion;
import com.amazonaws.services.ec2.model.Tag;
import com.amazonaws.services.ec2.model.transform.IpamOperatingRegionStaxUnmarshaller;
import com.amazonaws.services.ec2.model.transform.TagStaxUnmarshaller;
import com.amazonaws.transform.SimpleTypeStaxUnmarshallers;
import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import java.util.ArrayList;
import javax.xml.stream.events.XMLEvent;

public class IpamStaxUnmarshaller
implements Unmarshaller<Ipam, StaxUnmarshallerContext> {
    private static IpamStaxUnmarshaller instance;

    public Ipam unmarshall(StaxUnmarshallerContext context) throws Exception {
        Ipam ipam = new Ipam();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (true) {
            XMLEvent xmlEvent;
            if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                return ipam;
            }
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("ownerId", targetDepth)) {
                    ipam.setOwnerId(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("ipamId", targetDepth)) {
                    ipam.setIpamId(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("ipamArn", targetDepth)) {
                    ipam.setIpamArn(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("ipamRegion", targetDepth)) {
                    ipam.setIpamRegion(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("publicDefaultScopeId", targetDepth)) {
                    ipam.setPublicDefaultScopeId(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("privateDefaultScopeId", targetDepth)) {
                    ipam.setPrivateDefaultScopeId(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("scopeCount", targetDepth)) {
                    ipam.setScopeCount(SimpleTypeStaxUnmarshallers.IntegerStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("description", targetDepth)) {
                    ipam.setDescription(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("operatingRegionSet", targetDepth)) {
                    ipam.withOperatingRegions(new ArrayList<IpamOperatingRegion>());
                    continue;
                }
                if (context.testExpression("operatingRegionSet/item", targetDepth)) {
                    ipam.withOperatingRegions(IpamOperatingRegionStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("state", targetDepth)) {
                    ipam.setState(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("tagSet", targetDepth)) {
                    ipam.withTags(new ArrayList<Tag>());
                    continue;
                }
                if (context.testExpression("tagSet/item", targetDepth)) {
                    ipam.withTags(TagStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("defaultResourceDiscoveryId", targetDepth)) {
                    ipam.setDefaultResourceDiscoveryId(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("defaultResourceDiscoveryAssociationId", targetDepth)) {
                    ipam.setDefaultResourceDiscoveryAssociationId(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("resourceDiscoveryAssociationCount", targetDepth)) {
                    ipam.setResourceDiscoveryAssociationCount(SimpleTypeStaxUnmarshallers.IntegerStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("stateMessage", targetDepth)) {
                    ipam.setStateMessage(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("tier", targetDepth)) continue;
                ipam.setTier(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
        }
        return ipam;
    }

    public static IpamStaxUnmarshaller getInstance() {
        if (instance == null) {
            instance = new IpamStaxUnmarshaller();
        }
        return instance;
    }
}

