/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model;

import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.ec2.model.BootModeType;
import com.amazonaws.services.ec2.model.EbsInfo;
import com.amazonaws.services.ec2.model.FpgaInfo;
import com.amazonaws.services.ec2.model.GpuInfo;
import com.amazonaws.services.ec2.model.InferenceAcceleratorInfo;
import com.amazonaws.services.ec2.model.InstanceStorageInfo;
import com.amazonaws.services.ec2.model.InstanceType;
import com.amazonaws.services.ec2.model.InstanceTypeHypervisor;
import com.amazonaws.services.ec2.model.MediaAcceleratorInfo;
import com.amazonaws.services.ec2.model.MemoryInfo;
import com.amazonaws.services.ec2.model.NetworkInfo;
import com.amazonaws.services.ec2.model.NeuronInfo;
import com.amazonaws.services.ec2.model.NitroEnclavesSupport;
import com.amazonaws.services.ec2.model.NitroTpmInfo;
import com.amazonaws.services.ec2.model.NitroTpmSupport;
import com.amazonaws.services.ec2.model.PhcSupport;
import com.amazonaws.services.ec2.model.PlacementGroupInfo;
import com.amazonaws.services.ec2.model.ProcessorInfo;
import com.amazonaws.services.ec2.model.RootDeviceType;
import com.amazonaws.services.ec2.model.UsageClassType;
import com.amazonaws.services.ec2.model.VCpuInfo;
import com.amazonaws.services.ec2.model.VirtualizationType;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class InstanceTypeInfo
implements Serializable,
Cloneable {
    private String instanceType;
    private Boolean currentGeneration;
    private Boolean freeTierEligible;
    private SdkInternalList<String> supportedUsageClasses;
    private SdkInternalList<String> supportedRootDeviceTypes;
    private SdkInternalList<String> supportedVirtualizationTypes;
    private Boolean bareMetal;
    private String hypervisor;
    private ProcessorInfo processorInfo;
    private VCpuInfo vCpuInfo;
    private MemoryInfo memoryInfo;
    private Boolean instanceStorageSupported;
    private InstanceStorageInfo instanceStorageInfo;
    private EbsInfo ebsInfo;
    private NetworkInfo networkInfo;
    private GpuInfo gpuInfo;
    private FpgaInfo fpgaInfo;
    private PlacementGroupInfo placementGroupInfo;
    private InferenceAcceleratorInfo inferenceAcceleratorInfo;
    private Boolean hibernationSupported;
    private Boolean burstablePerformanceSupported;
    private Boolean dedicatedHostsSupported;
    private Boolean autoRecoverySupported;
    private SdkInternalList<String> supportedBootModes;
    private String nitroEnclavesSupport;
    private String nitroTpmSupport;
    private NitroTpmInfo nitroTpmInfo;
    private MediaAcceleratorInfo mediaAcceleratorInfo;
    private NeuronInfo neuronInfo;
    private String phcSupport;

    public void setInstanceType(String instanceType) {
        this.instanceType = instanceType;
    }

    public String getInstanceType() {
        return this.instanceType;
    }

    public InstanceTypeInfo withInstanceType(String instanceType) {
        this.setInstanceType(instanceType);
        return this;
    }

    public InstanceTypeInfo withInstanceType(InstanceType instanceType) {
        this.instanceType = instanceType.toString();
        return this;
    }

    public void setCurrentGeneration(Boolean currentGeneration) {
        this.currentGeneration = currentGeneration;
    }

    public Boolean getCurrentGeneration() {
        return this.currentGeneration;
    }

    public InstanceTypeInfo withCurrentGeneration(Boolean currentGeneration) {
        this.setCurrentGeneration(currentGeneration);
        return this;
    }

    public Boolean isCurrentGeneration() {
        return this.currentGeneration;
    }

    public void setFreeTierEligible(Boolean freeTierEligible) {
        this.freeTierEligible = freeTierEligible;
    }

    public Boolean getFreeTierEligible() {
        return this.freeTierEligible;
    }

    public InstanceTypeInfo withFreeTierEligible(Boolean freeTierEligible) {
        this.setFreeTierEligible(freeTierEligible);
        return this;
    }

    public Boolean isFreeTierEligible() {
        return this.freeTierEligible;
    }

    public List<String> getSupportedUsageClasses() {
        if (this.supportedUsageClasses == null) {
            this.supportedUsageClasses = new SdkInternalList();
        }
        return this.supportedUsageClasses;
    }

    public void setSupportedUsageClasses(Collection<String> supportedUsageClasses) {
        if (supportedUsageClasses == null) {
            this.supportedUsageClasses = null;
            return;
        }
        this.supportedUsageClasses = new SdkInternalList(supportedUsageClasses);
    }

    public InstanceTypeInfo withSupportedUsageClasses(String ... supportedUsageClasses) {
        if (this.supportedUsageClasses == null) {
            this.setSupportedUsageClasses((Collection<String>)new SdkInternalList(supportedUsageClasses.length));
        }
        for (String ele : supportedUsageClasses) {
            this.supportedUsageClasses.add((Object)ele);
        }
        return this;
    }

    public InstanceTypeInfo withSupportedUsageClasses(Collection<String> supportedUsageClasses) {
        this.setSupportedUsageClasses(supportedUsageClasses);
        return this;
    }

    public InstanceTypeInfo withSupportedUsageClasses(UsageClassType ... supportedUsageClasses) {
        SdkInternalList supportedUsageClassesCopy = new SdkInternalList(supportedUsageClasses.length);
        for (UsageClassType value : supportedUsageClasses) {
            supportedUsageClassesCopy.add((Object)value.toString());
        }
        if (this.getSupportedUsageClasses() == null) {
            this.setSupportedUsageClasses((Collection<String>)supportedUsageClassesCopy);
        } else {
            this.getSupportedUsageClasses().addAll((Collection<String>)supportedUsageClassesCopy);
        }
        return this;
    }

    public List<String> getSupportedRootDeviceTypes() {
        if (this.supportedRootDeviceTypes == null) {
            this.supportedRootDeviceTypes = new SdkInternalList();
        }
        return this.supportedRootDeviceTypes;
    }

    public void setSupportedRootDeviceTypes(Collection<String> supportedRootDeviceTypes) {
        if (supportedRootDeviceTypes == null) {
            this.supportedRootDeviceTypes = null;
            return;
        }
        this.supportedRootDeviceTypes = new SdkInternalList(supportedRootDeviceTypes);
    }

    public InstanceTypeInfo withSupportedRootDeviceTypes(String ... supportedRootDeviceTypes) {
        if (this.supportedRootDeviceTypes == null) {
            this.setSupportedRootDeviceTypes((Collection<String>)new SdkInternalList(supportedRootDeviceTypes.length));
        }
        for (String ele : supportedRootDeviceTypes) {
            this.supportedRootDeviceTypes.add((Object)ele);
        }
        return this;
    }

    public InstanceTypeInfo withSupportedRootDeviceTypes(Collection<String> supportedRootDeviceTypes) {
        this.setSupportedRootDeviceTypes(supportedRootDeviceTypes);
        return this;
    }

    public InstanceTypeInfo withSupportedRootDeviceTypes(RootDeviceType ... supportedRootDeviceTypes) {
        SdkInternalList supportedRootDeviceTypesCopy = new SdkInternalList(supportedRootDeviceTypes.length);
        for (RootDeviceType value : supportedRootDeviceTypes) {
            supportedRootDeviceTypesCopy.add((Object)value.toString());
        }
        if (this.getSupportedRootDeviceTypes() == null) {
            this.setSupportedRootDeviceTypes((Collection<String>)supportedRootDeviceTypesCopy);
        } else {
            this.getSupportedRootDeviceTypes().addAll((Collection<String>)supportedRootDeviceTypesCopy);
        }
        return this;
    }

    public List<String> getSupportedVirtualizationTypes() {
        if (this.supportedVirtualizationTypes == null) {
            this.supportedVirtualizationTypes = new SdkInternalList();
        }
        return this.supportedVirtualizationTypes;
    }

    public void setSupportedVirtualizationTypes(Collection<String> supportedVirtualizationTypes) {
        if (supportedVirtualizationTypes == null) {
            this.supportedVirtualizationTypes = null;
            return;
        }
        this.supportedVirtualizationTypes = new SdkInternalList(supportedVirtualizationTypes);
    }

    public InstanceTypeInfo withSupportedVirtualizationTypes(String ... supportedVirtualizationTypes) {
        if (this.supportedVirtualizationTypes == null) {
            this.setSupportedVirtualizationTypes((Collection<String>)new SdkInternalList(supportedVirtualizationTypes.length));
        }
        for (String ele : supportedVirtualizationTypes) {
            this.supportedVirtualizationTypes.add((Object)ele);
        }
        return this;
    }

    public InstanceTypeInfo withSupportedVirtualizationTypes(Collection<String> supportedVirtualizationTypes) {
        this.setSupportedVirtualizationTypes(supportedVirtualizationTypes);
        return this;
    }

    public InstanceTypeInfo withSupportedVirtualizationTypes(VirtualizationType ... supportedVirtualizationTypes) {
        SdkInternalList supportedVirtualizationTypesCopy = new SdkInternalList(supportedVirtualizationTypes.length);
        for (VirtualizationType value : supportedVirtualizationTypes) {
            supportedVirtualizationTypesCopy.add((Object)value.toString());
        }
        if (this.getSupportedVirtualizationTypes() == null) {
            this.setSupportedVirtualizationTypes((Collection<String>)supportedVirtualizationTypesCopy);
        } else {
            this.getSupportedVirtualizationTypes().addAll((Collection<String>)supportedVirtualizationTypesCopy);
        }
        return this;
    }

    public void setBareMetal(Boolean bareMetal) {
        this.bareMetal = bareMetal;
    }

    public Boolean getBareMetal() {
        return this.bareMetal;
    }

    public InstanceTypeInfo withBareMetal(Boolean bareMetal) {
        this.setBareMetal(bareMetal);
        return this;
    }

    public Boolean isBareMetal() {
        return this.bareMetal;
    }

    public void setHypervisor(String hypervisor) {
        this.hypervisor = hypervisor;
    }

    public String getHypervisor() {
        return this.hypervisor;
    }

    public InstanceTypeInfo withHypervisor(String hypervisor) {
        this.setHypervisor(hypervisor);
        return this;
    }

    public InstanceTypeInfo withHypervisor(InstanceTypeHypervisor hypervisor) {
        this.hypervisor = hypervisor.toString();
        return this;
    }

    public void setProcessorInfo(ProcessorInfo processorInfo) {
        this.processorInfo = processorInfo;
    }

    public ProcessorInfo getProcessorInfo() {
        return this.processorInfo;
    }

    public InstanceTypeInfo withProcessorInfo(ProcessorInfo processorInfo) {
        this.setProcessorInfo(processorInfo);
        return this;
    }

    public void setVCpuInfo(VCpuInfo vCpuInfo) {
        this.vCpuInfo = vCpuInfo;
    }

    public VCpuInfo getVCpuInfo() {
        return this.vCpuInfo;
    }

    public InstanceTypeInfo withVCpuInfo(VCpuInfo vCpuInfo) {
        this.setVCpuInfo(vCpuInfo);
        return this;
    }

    public void setMemoryInfo(MemoryInfo memoryInfo) {
        this.memoryInfo = memoryInfo;
    }

    public MemoryInfo getMemoryInfo() {
        return this.memoryInfo;
    }

    public InstanceTypeInfo withMemoryInfo(MemoryInfo memoryInfo) {
        this.setMemoryInfo(memoryInfo);
        return this;
    }

    public void setInstanceStorageSupported(Boolean instanceStorageSupported) {
        this.instanceStorageSupported = instanceStorageSupported;
    }

    public Boolean getInstanceStorageSupported() {
        return this.instanceStorageSupported;
    }

    public InstanceTypeInfo withInstanceStorageSupported(Boolean instanceStorageSupported) {
        this.setInstanceStorageSupported(instanceStorageSupported);
        return this;
    }

    public Boolean isInstanceStorageSupported() {
        return this.instanceStorageSupported;
    }

    public void setInstanceStorageInfo(InstanceStorageInfo instanceStorageInfo) {
        this.instanceStorageInfo = instanceStorageInfo;
    }

    public InstanceStorageInfo getInstanceStorageInfo() {
        return this.instanceStorageInfo;
    }

    public InstanceTypeInfo withInstanceStorageInfo(InstanceStorageInfo instanceStorageInfo) {
        this.setInstanceStorageInfo(instanceStorageInfo);
        return this;
    }

    public void setEbsInfo(EbsInfo ebsInfo) {
        this.ebsInfo = ebsInfo;
    }

    public EbsInfo getEbsInfo() {
        return this.ebsInfo;
    }

    public InstanceTypeInfo withEbsInfo(EbsInfo ebsInfo) {
        this.setEbsInfo(ebsInfo);
        return this;
    }

    public void setNetworkInfo(NetworkInfo networkInfo) {
        this.networkInfo = networkInfo;
    }

    public NetworkInfo getNetworkInfo() {
        return this.networkInfo;
    }

    public InstanceTypeInfo withNetworkInfo(NetworkInfo networkInfo) {
        this.setNetworkInfo(networkInfo);
        return this;
    }

    public void setGpuInfo(GpuInfo gpuInfo) {
        this.gpuInfo = gpuInfo;
    }

    public GpuInfo getGpuInfo() {
        return this.gpuInfo;
    }

    public InstanceTypeInfo withGpuInfo(GpuInfo gpuInfo) {
        this.setGpuInfo(gpuInfo);
        return this;
    }

    public void setFpgaInfo(FpgaInfo fpgaInfo) {
        this.fpgaInfo = fpgaInfo;
    }

    public FpgaInfo getFpgaInfo() {
        return this.fpgaInfo;
    }

    public InstanceTypeInfo withFpgaInfo(FpgaInfo fpgaInfo) {
        this.setFpgaInfo(fpgaInfo);
        return this;
    }

    public void setPlacementGroupInfo(PlacementGroupInfo placementGroupInfo) {
        this.placementGroupInfo = placementGroupInfo;
    }

    public PlacementGroupInfo getPlacementGroupInfo() {
        return this.placementGroupInfo;
    }

    public InstanceTypeInfo withPlacementGroupInfo(PlacementGroupInfo placementGroupInfo) {
        this.setPlacementGroupInfo(placementGroupInfo);
        return this;
    }

    public void setInferenceAcceleratorInfo(InferenceAcceleratorInfo inferenceAcceleratorInfo) {
        this.inferenceAcceleratorInfo = inferenceAcceleratorInfo;
    }

    public InferenceAcceleratorInfo getInferenceAcceleratorInfo() {
        return this.inferenceAcceleratorInfo;
    }

    public InstanceTypeInfo withInferenceAcceleratorInfo(InferenceAcceleratorInfo inferenceAcceleratorInfo) {
        this.setInferenceAcceleratorInfo(inferenceAcceleratorInfo);
        return this;
    }

    public void setHibernationSupported(Boolean hibernationSupported) {
        this.hibernationSupported = hibernationSupported;
    }

    public Boolean getHibernationSupported() {
        return this.hibernationSupported;
    }

    public InstanceTypeInfo withHibernationSupported(Boolean hibernationSupported) {
        this.setHibernationSupported(hibernationSupported);
        return this;
    }

    public Boolean isHibernationSupported() {
        return this.hibernationSupported;
    }

    public void setBurstablePerformanceSupported(Boolean burstablePerformanceSupported) {
        this.burstablePerformanceSupported = burstablePerformanceSupported;
    }

    public Boolean getBurstablePerformanceSupported() {
        return this.burstablePerformanceSupported;
    }

    public InstanceTypeInfo withBurstablePerformanceSupported(Boolean burstablePerformanceSupported) {
        this.setBurstablePerformanceSupported(burstablePerformanceSupported);
        return this;
    }

    public Boolean isBurstablePerformanceSupported() {
        return this.burstablePerformanceSupported;
    }

    public void setDedicatedHostsSupported(Boolean dedicatedHostsSupported) {
        this.dedicatedHostsSupported = dedicatedHostsSupported;
    }

    public Boolean getDedicatedHostsSupported() {
        return this.dedicatedHostsSupported;
    }

    public InstanceTypeInfo withDedicatedHostsSupported(Boolean dedicatedHostsSupported) {
        this.setDedicatedHostsSupported(dedicatedHostsSupported);
        return this;
    }

    public Boolean isDedicatedHostsSupported() {
        return this.dedicatedHostsSupported;
    }

    public void setAutoRecoverySupported(Boolean autoRecoverySupported) {
        this.autoRecoverySupported = autoRecoverySupported;
    }

    public Boolean getAutoRecoverySupported() {
        return this.autoRecoverySupported;
    }

    public InstanceTypeInfo withAutoRecoverySupported(Boolean autoRecoverySupported) {
        this.setAutoRecoverySupported(autoRecoverySupported);
        return this;
    }

    public Boolean isAutoRecoverySupported() {
        return this.autoRecoverySupported;
    }

    public List<String> getSupportedBootModes() {
        if (this.supportedBootModes == null) {
            this.supportedBootModes = new SdkInternalList();
        }
        return this.supportedBootModes;
    }

    public void setSupportedBootModes(Collection<String> supportedBootModes) {
        if (supportedBootModes == null) {
            this.supportedBootModes = null;
            return;
        }
        this.supportedBootModes = new SdkInternalList(supportedBootModes);
    }

    public InstanceTypeInfo withSupportedBootModes(String ... supportedBootModes) {
        if (this.supportedBootModes == null) {
            this.setSupportedBootModes((Collection<String>)new SdkInternalList(supportedBootModes.length));
        }
        for (String ele : supportedBootModes) {
            this.supportedBootModes.add((Object)ele);
        }
        return this;
    }

    public InstanceTypeInfo withSupportedBootModes(Collection<String> supportedBootModes) {
        this.setSupportedBootModes(supportedBootModes);
        return this;
    }

    public InstanceTypeInfo withSupportedBootModes(BootModeType ... supportedBootModes) {
        SdkInternalList supportedBootModesCopy = new SdkInternalList(supportedBootModes.length);
        for (BootModeType value : supportedBootModes) {
            supportedBootModesCopy.add((Object)value.toString());
        }
        if (this.getSupportedBootModes() == null) {
            this.setSupportedBootModes((Collection<String>)supportedBootModesCopy);
        } else {
            this.getSupportedBootModes().addAll((Collection<String>)supportedBootModesCopy);
        }
        return this;
    }

    public void setNitroEnclavesSupport(String nitroEnclavesSupport) {
        this.nitroEnclavesSupport = nitroEnclavesSupport;
    }

    public String getNitroEnclavesSupport() {
        return this.nitroEnclavesSupport;
    }

    public InstanceTypeInfo withNitroEnclavesSupport(String nitroEnclavesSupport) {
        this.setNitroEnclavesSupport(nitroEnclavesSupport);
        return this;
    }

    public InstanceTypeInfo withNitroEnclavesSupport(NitroEnclavesSupport nitroEnclavesSupport) {
        this.nitroEnclavesSupport = nitroEnclavesSupport.toString();
        return this;
    }

    public void setNitroTpmSupport(String nitroTpmSupport) {
        this.nitroTpmSupport = nitroTpmSupport;
    }

    public String getNitroTpmSupport() {
        return this.nitroTpmSupport;
    }

    public InstanceTypeInfo withNitroTpmSupport(String nitroTpmSupport) {
        this.setNitroTpmSupport(nitroTpmSupport);
        return this;
    }

    public InstanceTypeInfo withNitroTpmSupport(NitroTpmSupport nitroTpmSupport) {
        this.nitroTpmSupport = nitroTpmSupport.toString();
        return this;
    }

    public void setNitroTpmInfo(NitroTpmInfo nitroTpmInfo) {
        this.nitroTpmInfo = nitroTpmInfo;
    }

    public NitroTpmInfo getNitroTpmInfo() {
        return this.nitroTpmInfo;
    }

    public InstanceTypeInfo withNitroTpmInfo(NitroTpmInfo nitroTpmInfo) {
        this.setNitroTpmInfo(nitroTpmInfo);
        return this;
    }

    public void setMediaAcceleratorInfo(MediaAcceleratorInfo mediaAcceleratorInfo) {
        this.mediaAcceleratorInfo = mediaAcceleratorInfo;
    }

    public MediaAcceleratorInfo getMediaAcceleratorInfo() {
        return this.mediaAcceleratorInfo;
    }

    public InstanceTypeInfo withMediaAcceleratorInfo(MediaAcceleratorInfo mediaAcceleratorInfo) {
        this.setMediaAcceleratorInfo(mediaAcceleratorInfo);
        return this;
    }

    public void setNeuronInfo(NeuronInfo neuronInfo) {
        this.neuronInfo = neuronInfo;
    }

    public NeuronInfo getNeuronInfo() {
        return this.neuronInfo;
    }

    public InstanceTypeInfo withNeuronInfo(NeuronInfo neuronInfo) {
        this.setNeuronInfo(neuronInfo);
        return this;
    }

    public void setPhcSupport(String phcSupport) {
        this.phcSupport = phcSupport;
    }

    public String getPhcSupport() {
        return this.phcSupport;
    }

    public InstanceTypeInfo withPhcSupport(String phcSupport) {
        this.setPhcSupport(phcSupport);
        return this;
    }

    public InstanceTypeInfo withPhcSupport(PhcSupport phcSupport) {
        this.phcSupport = phcSupport.toString();
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getInstanceType() != null) {
            sb.append("InstanceType: ").append(this.getInstanceType()).append(",");
        }
        if (this.getCurrentGeneration() != null) {
            sb.append("CurrentGeneration: ").append(this.getCurrentGeneration()).append(",");
        }
        if (this.getFreeTierEligible() != null) {
            sb.append("FreeTierEligible: ").append(this.getFreeTierEligible()).append(",");
        }
        if (this.getSupportedUsageClasses() != null) {
            sb.append("SupportedUsageClasses: ").append(this.getSupportedUsageClasses()).append(",");
        }
        if (this.getSupportedRootDeviceTypes() != null) {
            sb.append("SupportedRootDeviceTypes: ").append(this.getSupportedRootDeviceTypes()).append(",");
        }
        if (this.getSupportedVirtualizationTypes() != null) {
            sb.append("SupportedVirtualizationTypes: ").append(this.getSupportedVirtualizationTypes()).append(",");
        }
        if (this.getBareMetal() != null) {
            sb.append("BareMetal: ").append(this.getBareMetal()).append(",");
        }
        if (this.getHypervisor() != null) {
            sb.append("Hypervisor: ").append(this.getHypervisor()).append(",");
        }
        if (this.getProcessorInfo() != null) {
            sb.append("ProcessorInfo: ").append(this.getProcessorInfo()).append(",");
        }
        if (this.getVCpuInfo() != null) {
            sb.append("VCpuInfo: ").append(this.getVCpuInfo()).append(",");
        }
        if (this.getMemoryInfo() != null) {
            sb.append("MemoryInfo: ").append(this.getMemoryInfo()).append(",");
        }
        if (this.getInstanceStorageSupported() != null) {
            sb.append("InstanceStorageSupported: ").append(this.getInstanceStorageSupported()).append(",");
        }
        if (this.getInstanceStorageInfo() != null) {
            sb.append("InstanceStorageInfo: ").append(this.getInstanceStorageInfo()).append(",");
        }
        if (this.getEbsInfo() != null) {
            sb.append("EbsInfo: ").append(this.getEbsInfo()).append(",");
        }
        if (this.getNetworkInfo() != null) {
            sb.append("NetworkInfo: ").append(this.getNetworkInfo()).append(",");
        }
        if (this.getGpuInfo() != null) {
            sb.append("GpuInfo: ").append(this.getGpuInfo()).append(",");
        }
        if (this.getFpgaInfo() != null) {
            sb.append("FpgaInfo: ").append(this.getFpgaInfo()).append(",");
        }
        if (this.getPlacementGroupInfo() != null) {
            sb.append("PlacementGroupInfo: ").append(this.getPlacementGroupInfo()).append(",");
        }
        if (this.getInferenceAcceleratorInfo() != null) {
            sb.append("InferenceAcceleratorInfo: ").append(this.getInferenceAcceleratorInfo()).append(",");
        }
        if (this.getHibernationSupported() != null) {
            sb.append("HibernationSupported: ").append(this.getHibernationSupported()).append(",");
        }
        if (this.getBurstablePerformanceSupported() != null) {
            sb.append("BurstablePerformanceSupported: ").append(this.getBurstablePerformanceSupported()).append(",");
        }
        if (this.getDedicatedHostsSupported() != null) {
            sb.append("DedicatedHostsSupported: ").append(this.getDedicatedHostsSupported()).append(",");
        }
        if (this.getAutoRecoverySupported() != null) {
            sb.append("AutoRecoverySupported: ").append(this.getAutoRecoverySupported()).append(",");
        }
        if (this.getSupportedBootModes() != null) {
            sb.append("SupportedBootModes: ").append(this.getSupportedBootModes()).append(",");
        }
        if (this.getNitroEnclavesSupport() != null) {
            sb.append("NitroEnclavesSupport: ").append(this.getNitroEnclavesSupport()).append(",");
        }
        if (this.getNitroTpmSupport() != null) {
            sb.append("NitroTpmSupport: ").append(this.getNitroTpmSupport()).append(",");
        }
        if (this.getNitroTpmInfo() != null) {
            sb.append("NitroTpmInfo: ").append(this.getNitroTpmInfo()).append(",");
        }
        if (this.getMediaAcceleratorInfo() != null) {
            sb.append("MediaAcceleratorInfo: ").append(this.getMediaAcceleratorInfo()).append(",");
        }
        if (this.getNeuronInfo() != null) {
            sb.append("NeuronInfo: ").append(this.getNeuronInfo()).append(",");
        }
        if (this.getPhcSupport() != null) {
            sb.append("PhcSupport: ").append(this.getPhcSupport());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InstanceTypeInfo)) {
            return false;
        }
        InstanceTypeInfo other = (InstanceTypeInfo)obj;
        if (other.getInstanceType() == null ^ this.getInstanceType() == null) {
            return false;
        }
        if (other.getInstanceType() != null && !other.getInstanceType().equals(this.getInstanceType())) {
            return false;
        }
        if (other.getCurrentGeneration() == null ^ this.getCurrentGeneration() == null) {
            return false;
        }
        if (other.getCurrentGeneration() != null && !other.getCurrentGeneration().equals(this.getCurrentGeneration())) {
            return false;
        }
        if (other.getFreeTierEligible() == null ^ this.getFreeTierEligible() == null) {
            return false;
        }
        if (other.getFreeTierEligible() != null && !other.getFreeTierEligible().equals(this.getFreeTierEligible())) {
            return false;
        }
        if (other.getSupportedUsageClasses() == null ^ this.getSupportedUsageClasses() == null) {
            return false;
        }
        if (other.getSupportedUsageClasses() != null && !other.getSupportedUsageClasses().equals(this.getSupportedUsageClasses())) {
            return false;
        }
        if (other.getSupportedRootDeviceTypes() == null ^ this.getSupportedRootDeviceTypes() == null) {
            return false;
        }
        if (other.getSupportedRootDeviceTypes() != null && !other.getSupportedRootDeviceTypes().equals(this.getSupportedRootDeviceTypes())) {
            return false;
        }
        if (other.getSupportedVirtualizationTypes() == null ^ this.getSupportedVirtualizationTypes() == null) {
            return false;
        }
        if (other.getSupportedVirtualizationTypes() != null && !other.getSupportedVirtualizationTypes().equals(this.getSupportedVirtualizationTypes())) {
            return false;
        }
        if (other.getBareMetal() == null ^ this.getBareMetal() == null) {
            return false;
        }
        if (other.getBareMetal() != null && !other.getBareMetal().equals(this.getBareMetal())) {
            return false;
        }
        if (other.getHypervisor() == null ^ this.getHypervisor() == null) {
            return false;
        }
        if (other.getHypervisor() != null && !other.getHypervisor().equals(this.getHypervisor())) {
            return false;
        }
        if (other.getProcessorInfo() == null ^ this.getProcessorInfo() == null) {
            return false;
        }
        if (other.getProcessorInfo() != null && !other.getProcessorInfo().equals(this.getProcessorInfo())) {
            return false;
        }
        if (other.getVCpuInfo() == null ^ this.getVCpuInfo() == null) {
            return false;
        }
        if (other.getVCpuInfo() != null && !other.getVCpuInfo().equals(this.getVCpuInfo())) {
            return false;
        }
        if (other.getMemoryInfo() == null ^ this.getMemoryInfo() == null) {
            return false;
        }
        if (other.getMemoryInfo() != null && !other.getMemoryInfo().equals(this.getMemoryInfo())) {
            return false;
        }
        if (other.getInstanceStorageSupported() == null ^ this.getInstanceStorageSupported() == null) {
            return false;
        }
        if (other.getInstanceStorageSupported() != null && !other.getInstanceStorageSupported().equals(this.getInstanceStorageSupported())) {
            return false;
        }
        if (other.getInstanceStorageInfo() == null ^ this.getInstanceStorageInfo() == null) {
            return false;
        }
        if (other.getInstanceStorageInfo() != null && !other.getInstanceStorageInfo().equals(this.getInstanceStorageInfo())) {
            return false;
        }
        if (other.getEbsInfo() == null ^ this.getEbsInfo() == null) {
            return false;
        }
        if (other.getEbsInfo() != null && !other.getEbsInfo().equals(this.getEbsInfo())) {
            return false;
        }
        if (other.getNetworkInfo() == null ^ this.getNetworkInfo() == null) {
            return false;
        }
        if (other.getNetworkInfo() != null && !other.getNetworkInfo().equals(this.getNetworkInfo())) {
            return false;
        }
        if (other.getGpuInfo() == null ^ this.getGpuInfo() == null) {
            return false;
        }
        if (other.getGpuInfo() != null && !other.getGpuInfo().equals(this.getGpuInfo())) {
            return false;
        }
        if (other.getFpgaInfo() == null ^ this.getFpgaInfo() == null) {
            return false;
        }
        if (other.getFpgaInfo() != null && !other.getFpgaInfo().equals(this.getFpgaInfo())) {
            return false;
        }
        if (other.getPlacementGroupInfo() == null ^ this.getPlacementGroupInfo() == null) {
            return false;
        }
        if (other.getPlacementGroupInfo() != null && !other.getPlacementGroupInfo().equals(this.getPlacementGroupInfo())) {
            return false;
        }
        if (other.getInferenceAcceleratorInfo() == null ^ this.getInferenceAcceleratorInfo() == null) {
            return false;
        }
        if (other.getInferenceAcceleratorInfo() != null && !other.getInferenceAcceleratorInfo().equals(this.getInferenceAcceleratorInfo())) {
            return false;
        }
        if (other.getHibernationSupported() == null ^ this.getHibernationSupported() == null) {
            return false;
        }
        if (other.getHibernationSupported() != null && !other.getHibernationSupported().equals(this.getHibernationSupported())) {
            return false;
        }
        if (other.getBurstablePerformanceSupported() == null ^ this.getBurstablePerformanceSupported() == null) {
            return false;
        }
        if (other.getBurstablePerformanceSupported() != null && !other.getBurstablePerformanceSupported().equals(this.getBurstablePerformanceSupported())) {
            return false;
        }
        if (other.getDedicatedHostsSupported() == null ^ this.getDedicatedHostsSupported() == null) {
            return false;
        }
        if (other.getDedicatedHostsSupported() != null && !other.getDedicatedHostsSupported().equals(this.getDedicatedHostsSupported())) {
            return false;
        }
        if (other.getAutoRecoverySupported() == null ^ this.getAutoRecoverySupported() == null) {
            return false;
        }
        if (other.getAutoRecoverySupported() != null && !other.getAutoRecoverySupported().equals(this.getAutoRecoverySupported())) {
            return false;
        }
        if (other.getSupportedBootModes() == null ^ this.getSupportedBootModes() == null) {
            return false;
        }
        if (other.getSupportedBootModes() != null && !other.getSupportedBootModes().equals(this.getSupportedBootModes())) {
            return false;
        }
        if (other.getNitroEnclavesSupport() == null ^ this.getNitroEnclavesSupport() == null) {
            return false;
        }
        if (other.getNitroEnclavesSupport() != null && !other.getNitroEnclavesSupport().equals(this.getNitroEnclavesSupport())) {
            return false;
        }
        if (other.getNitroTpmSupport() == null ^ this.getNitroTpmSupport() == null) {
            return false;
        }
        if (other.getNitroTpmSupport() != null && !other.getNitroTpmSupport().equals(this.getNitroTpmSupport())) {
            return false;
        }
        if (other.getNitroTpmInfo() == null ^ this.getNitroTpmInfo() == null) {
            return false;
        }
        if (other.getNitroTpmInfo() != null && !other.getNitroTpmInfo().equals(this.getNitroTpmInfo())) {
            return false;
        }
        if (other.getMediaAcceleratorInfo() == null ^ this.getMediaAcceleratorInfo() == null) {
            return false;
        }
        if (other.getMediaAcceleratorInfo() != null && !other.getMediaAcceleratorInfo().equals(this.getMediaAcceleratorInfo())) {
            return false;
        }
        if (other.getNeuronInfo() == null ^ this.getNeuronInfo() == null) {
            return false;
        }
        if (other.getNeuronInfo() != null && !other.getNeuronInfo().equals(this.getNeuronInfo())) {
            return false;
        }
        if (other.getPhcSupport() == null ^ this.getPhcSupport() == null) {
            return false;
        }
        return other.getPhcSupport() == null || other.getPhcSupport().equals(this.getPhcSupport());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getInstanceType() == null ? 0 : this.getInstanceType().hashCode());
        hashCode = 31 * hashCode + (this.getCurrentGeneration() == null ? 0 : this.getCurrentGeneration().hashCode());
        hashCode = 31 * hashCode + (this.getFreeTierEligible() == null ? 0 : this.getFreeTierEligible().hashCode());
        hashCode = 31 * hashCode + (this.getSupportedUsageClasses() == null ? 0 : this.getSupportedUsageClasses().hashCode());
        hashCode = 31 * hashCode + (this.getSupportedRootDeviceTypes() == null ? 0 : this.getSupportedRootDeviceTypes().hashCode());
        hashCode = 31 * hashCode + (this.getSupportedVirtualizationTypes() == null ? 0 : this.getSupportedVirtualizationTypes().hashCode());
        hashCode = 31 * hashCode + (this.getBareMetal() == null ? 0 : this.getBareMetal().hashCode());
        hashCode = 31 * hashCode + (this.getHypervisor() == null ? 0 : this.getHypervisor().hashCode());
        hashCode = 31 * hashCode + (this.getProcessorInfo() == null ? 0 : this.getProcessorInfo().hashCode());
        hashCode = 31 * hashCode + (this.getVCpuInfo() == null ? 0 : this.getVCpuInfo().hashCode());
        hashCode = 31 * hashCode + (this.getMemoryInfo() == null ? 0 : this.getMemoryInfo().hashCode());
        hashCode = 31 * hashCode + (this.getInstanceStorageSupported() == null ? 0 : this.getInstanceStorageSupported().hashCode());
        hashCode = 31 * hashCode + (this.getInstanceStorageInfo() == null ? 0 : this.getInstanceStorageInfo().hashCode());
        hashCode = 31 * hashCode + (this.getEbsInfo() == null ? 0 : this.getEbsInfo().hashCode());
        hashCode = 31 * hashCode + (this.getNetworkInfo() == null ? 0 : this.getNetworkInfo().hashCode());
        hashCode = 31 * hashCode + (this.getGpuInfo() == null ? 0 : this.getGpuInfo().hashCode());
        hashCode = 31 * hashCode + (this.getFpgaInfo() == null ? 0 : this.getFpgaInfo().hashCode());
        hashCode = 31 * hashCode + (this.getPlacementGroupInfo() == null ? 0 : this.getPlacementGroupInfo().hashCode());
        hashCode = 31 * hashCode + (this.getInferenceAcceleratorInfo() == null ? 0 : this.getInferenceAcceleratorInfo().hashCode());
        hashCode = 31 * hashCode + (this.getHibernationSupported() == null ? 0 : this.getHibernationSupported().hashCode());
        hashCode = 31 * hashCode + (this.getBurstablePerformanceSupported() == null ? 0 : this.getBurstablePerformanceSupported().hashCode());
        hashCode = 31 * hashCode + (this.getDedicatedHostsSupported() == null ? 0 : this.getDedicatedHostsSupported().hashCode());
        hashCode = 31 * hashCode + (this.getAutoRecoverySupported() == null ? 0 : this.getAutoRecoverySupported().hashCode());
        hashCode = 31 * hashCode + (this.getSupportedBootModes() == null ? 0 : this.getSupportedBootModes().hashCode());
        hashCode = 31 * hashCode + (this.getNitroEnclavesSupport() == null ? 0 : this.getNitroEnclavesSupport().hashCode());
        hashCode = 31 * hashCode + (this.getNitroTpmSupport() == null ? 0 : this.getNitroTpmSupport().hashCode());
        hashCode = 31 * hashCode + (this.getNitroTpmInfo() == null ? 0 : this.getNitroTpmInfo().hashCode());
        hashCode = 31 * hashCode + (this.getMediaAcceleratorInfo() == null ? 0 : this.getMediaAcceleratorInfo().hashCode());
        hashCode = 31 * hashCode + (this.getNeuronInfo() == null ? 0 : this.getNeuronInfo().hashCode());
        hashCode = 31 * hashCode + (this.getPhcSupport() == null ? 0 : this.getPhcSupport().hashCode());
        return hashCode;
    }

    public InstanceTypeInfo clone() {
        try {
            return (InstanceTypeInfo)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

