/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.ec2.model.ModifyVerifiedAccessEndpointEniOptions;
import com.amazonaws.services.ec2.model.ModifyVerifiedAccessEndpointLoadBalancerOptions;
import com.amazonaws.services.ec2.model.ModifyVerifiedAccessEndpointRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.IdempotentUtils;
import com.amazonaws.util.StringUtils;

public class ModifyVerifiedAccessEndpointRequestMarshaller
implements Marshaller<Request<ModifyVerifiedAccessEndpointRequest>, ModifyVerifiedAccessEndpointRequest> {
    public Request<ModifyVerifiedAccessEndpointRequest> marshall(ModifyVerifiedAccessEndpointRequest modifyVerifiedAccessEndpointRequest) {
        ModifyVerifiedAccessEndpointEniOptions networkInterfaceOptions;
        ModifyVerifiedAccessEndpointLoadBalancerOptions loadBalancerOptions;
        if (modifyVerifiedAccessEndpointRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)modifyVerifiedAccessEndpointRequest, "AmazonEC2");
        request.addParameter("Action", "ModifyVerifiedAccessEndpoint");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (modifyVerifiedAccessEndpointRequest.getVerifiedAccessEndpointId() != null) {
            request.addParameter("VerifiedAccessEndpointId", StringUtils.fromString((String)modifyVerifiedAccessEndpointRequest.getVerifiedAccessEndpointId()));
        }
        if (modifyVerifiedAccessEndpointRequest.getVerifiedAccessGroupId() != null) {
            request.addParameter("VerifiedAccessGroupId", StringUtils.fromString((String)modifyVerifiedAccessEndpointRequest.getVerifiedAccessGroupId()));
        }
        if ((loadBalancerOptions = modifyVerifiedAccessEndpointRequest.getLoadBalancerOptions()) != null) {
            SdkInternalList modifyVerifiedAccessEndpointLoadBalancerOptionsSubnetIdsList = (SdkInternalList)loadBalancerOptions.getSubnetIds();
            if (!modifyVerifiedAccessEndpointLoadBalancerOptionsSubnetIdsList.isEmpty() || !modifyVerifiedAccessEndpointLoadBalancerOptionsSubnetIdsList.isAutoConstruct()) {
                int subnetIdsListIndex = 1;
                for (String modifyVerifiedAccessEndpointLoadBalancerOptionsSubnetIdsListValue : modifyVerifiedAccessEndpointLoadBalancerOptionsSubnetIdsList) {
                    if (modifyVerifiedAccessEndpointLoadBalancerOptionsSubnetIdsListValue != null) {
                        request.addParameter("LoadBalancerOptions.SubnetId." + subnetIdsListIndex, StringUtils.fromString((String)modifyVerifiedAccessEndpointLoadBalancerOptionsSubnetIdsListValue));
                    }
                    ++subnetIdsListIndex;
                }
            }
            if (loadBalancerOptions.getProtocol() != null) {
                request.addParameter("LoadBalancerOptions.Protocol", StringUtils.fromString((String)loadBalancerOptions.getProtocol()));
            }
            if (loadBalancerOptions.getPort() != null) {
                request.addParameter("LoadBalancerOptions.Port", StringUtils.fromInteger((Integer)loadBalancerOptions.getPort()));
            }
        }
        if ((networkInterfaceOptions = modifyVerifiedAccessEndpointRequest.getNetworkInterfaceOptions()) != null) {
            if (networkInterfaceOptions.getProtocol() != null) {
                request.addParameter("NetworkInterfaceOptions.Protocol", StringUtils.fromString((String)networkInterfaceOptions.getProtocol()));
            }
            if (networkInterfaceOptions.getPort() != null) {
                request.addParameter("NetworkInterfaceOptions.Port", StringUtils.fromInteger((Integer)networkInterfaceOptions.getPort()));
            }
        }
        if (modifyVerifiedAccessEndpointRequest.getDescription() != null) {
            request.addParameter("Description", StringUtils.fromString((String)modifyVerifiedAccessEndpointRequest.getDescription()));
        }
        request.addParameter("ClientToken", IdempotentUtils.resolveString((String)modifyVerifiedAccessEndpointRequest.getClientToken()));
        return request;
    }
}

