/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.ec2.model.DescribeInstanceConnectEndpointsRequest;
import com.amazonaws.services.ec2.model.Filter;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class DescribeInstanceConnectEndpointsRequestMarshaller
implements Marshaller<Request<DescribeInstanceConnectEndpointsRequest>, DescribeInstanceConnectEndpointsRequest> {
    public Request<DescribeInstanceConnectEndpointsRequest> marshall(DescribeInstanceConnectEndpointsRequest describeInstanceConnectEndpointsRequest) {
        SdkInternalList describeInstanceConnectEndpointsRequestInstanceConnectEndpointIdsList;
        SdkInternalList describeInstanceConnectEndpointsRequestFiltersList;
        if (describeInstanceConnectEndpointsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)describeInstanceConnectEndpointsRequest, "AmazonEC2");
        request.addParameter("Action", "DescribeInstanceConnectEndpoints");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (describeInstanceConnectEndpointsRequest.getMaxResults() != null) {
            request.addParameter("MaxResults", StringUtils.fromInteger((Integer)describeInstanceConnectEndpointsRequest.getMaxResults()));
        }
        if (describeInstanceConnectEndpointsRequest.getNextToken() != null) {
            request.addParameter("NextToken", StringUtils.fromString((String)describeInstanceConnectEndpointsRequest.getNextToken()));
        }
        if (!(describeInstanceConnectEndpointsRequestFiltersList = (SdkInternalList)describeInstanceConnectEndpointsRequest.getFilters()).isEmpty() || !describeInstanceConnectEndpointsRequestFiltersList.isAutoConstruct()) {
            int filtersListIndex = 1;
            for (Filter describeInstanceConnectEndpointsRequestFiltersListValue : describeInstanceConnectEndpointsRequestFiltersList) {
                SdkInternalList filterValuesList;
                if (describeInstanceConnectEndpointsRequestFiltersListValue.getName() != null) {
                    request.addParameter("Filter." + filtersListIndex + ".Name", StringUtils.fromString((String)describeInstanceConnectEndpointsRequestFiltersListValue.getName()));
                }
                if (!(filterValuesList = (SdkInternalList)describeInstanceConnectEndpointsRequestFiltersListValue.getValues()).isEmpty() || !filterValuesList.isAutoConstruct()) {
                    int valuesListIndex = 1;
                    for (String filterValuesListValue : filterValuesList) {
                        if (filterValuesListValue != null) {
                            request.addParameter("Filter." + filtersListIndex + ".Value." + valuesListIndex, StringUtils.fromString((String)filterValuesListValue));
                        }
                        ++valuesListIndex;
                    }
                }
                ++filtersListIndex;
            }
        }
        if (!(describeInstanceConnectEndpointsRequestInstanceConnectEndpointIdsList = (SdkInternalList)describeInstanceConnectEndpointsRequest.getInstanceConnectEndpointIds()).isEmpty() || !describeInstanceConnectEndpointsRequestInstanceConnectEndpointIdsList.isAutoConstruct()) {
            int instanceConnectEndpointIdsListIndex = 1;
            for (String describeInstanceConnectEndpointsRequestInstanceConnectEndpointIdsListValue : describeInstanceConnectEndpointsRequestInstanceConnectEndpointIdsList) {
                if (describeInstanceConnectEndpointsRequestInstanceConnectEndpointIdsListValue != null) {
                    request.addParameter("InstanceConnectEndpointId." + instanceConnectEndpointIdsListIndex, StringUtils.fromString((String)describeInstanceConnectEndpointsRequestInstanceConnectEndpointIdsListValue));
                }
                ++instanceConnectEndpointIdsListIndex;
            }
        }
        return request;
    }
}

