/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.ec2.model.AddIpamOperatingRegion;
import com.amazonaws.services.ec2.model.CreateIpamResourceDiscoveryRequest;
import com.amazonaws.services.ec2.model.Tag;
import com.amazonaws.services.ec2.model.TagSpecification;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.IdempotentUtils;
import com.amazonaws.util.StringUtils;

public class CreateIpamResourceDiscoveryRequestMarshaller
implements Marshaller<Request<CreateIpamResourceDiscoveryRequest>, CreateIpamResourceDiscoveryRequest> {
    public Request<CreateIpamResourceDiscoveryRequest> marshall(CreateIpamResourceDiscoveryRequest createIpamResourceDiscoveryRequest) {
        SdkInternalList createIpamResourceDiscoveryRequestTagSpecificationsList;
        SdkInternalList createIpamResourceDiscoveryRequestOperatingRegionsList;
        if (createIpamResourceDiscoveryRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)createIpamResourceDiscoveryRequest, "AmazonEC2");
        request.addParameter("Action", "CreateIpamResourceDiscovery");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (createIpamResourceDiscoveryRequest.getDescription() != null) {
            request.addParameter("Description", StringUtils.fromString((String)createIpamResourceDiscoveryRequest.getDescription()));
        }
        if (!(createIpamResourceDiscoveryRequestOperatingRegionsList = (SdkInternalList)createIpamResourceDiscoveryRequest.getOperatingRegions()).isEmpty() || !createIpamResourceDiscoveryRequestOperatingRegionsList.isAutoConstruct()) {
            int operatingRegionsListIndex = 1;
            for (AddIpamOperatingRegion createIpamResourceDiscoveryRequestOperatingRegionsListValue : createIpamResourceDiscoveryRequestOperatingRegionsList) {
                if (createIpamResourceDiscoveryRequestOperatingRegionsListValue.getRegionName() != null) {
                    request.addParameter("OperatingRegion." + operatingRegionsListIndex + ".RegionName", StringUtils.fromString((String)createIpamResourceDiscoveryRequestOperatingRegionsListValue.getRegionName()));
                }
                ++operatingRegionsListIndex;
            }
        }
        if (!(createIpamResourceDiscoveryRequestTagSpecificationsList = (SdkInternalList)createIpamResourceDiscoveryRequest.getTagSpecifications()).isEmpty() || !createIpamResourceDiscoveryRequestTagSpecificationsList.isAutoConstruct()) {
            int tagSpecificationsListIndex = 1;
            for (TagSpecification createIpamResourceDiscoveryRequestTagSpecificationsListValue : createIpamResourceDiscoveryRequestTagSpecificationsList) {
                SdkInternalList tagSpecificationTagsList;
                if (createIpamResourceDiscoveryRequestTagSpecificationsListValue.getResourceType() != null) {
                    request.addParameter("TagSpecification." + tagSpecificationsListIndex + ".ResourceType", StringUtils.fromString((String)createIpamResourceDiscoveryRequestTagSpecificationsListValue.getResourceType()));
                }
                if (!(tagSpecificationTagsList = (SdkInternalList)createIpamResourceDiscoveryRequestTagSpecificationsListValue.getTags()).isEmpty() || !tagSpecificationTagsList.isAutoConstruct()) {
                    int tagsListIndex = 1;
                    for (Tag tagSpecificationTagsListValue : tagSpecificationTagsList) {
                        if (tagSpecificationTagsListValue.getKey() != null) {
                            request.addParameter("TagSpecification." + tagSpecificationsListIndex + ".Tag." + tagsListIndex + ".Key", StringUtils.fromString((String)tagSpecificationTagsListValue.getKey()));
                        }
                        if (tagSpecificationTagsListValue.getValue() != null) {
                            request.addParameter("TagSpecification." + tagSpecificationsListIndex + ".Tag." + tagsListIndex + ".Value", StringUtils.fromString((String)tagSpecificationTagsListValue.getValue()));
                        }
                        ++tagsListIndex;
                    }
                }
                ++tagSpecificationsListIndex;
            }
        }
        request.addParameter("ClientToken", IdempotentUtils.resolveString((String)createIpamResourceDiscoveryRequest.getClientToken()));
        return request;
    }
}

