/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.databasemigrationservice.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.databasemigrationservice.model.Replication;
import java.util.Date;
import java.util.List;

@SdkInternalApi
public class ReplicationMarshaller {
    private static final MarshallingInfo<String> REPLICATIONCONFIGIDENTIFIER_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ReplicationConfigIdentifier").build();
    private static final MarshallingInfo<String> REPLICATIONCONFIGARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ReplicationConfigArn").build();
    private static final MarshallingInfo<String> SOURCEENDPOINTARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SourceEndpointArn").build();
    private static final MarshallingInfo<String> TARGETENDPOINTARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TargetEndpointArn").build();
    private static final MarshallingInfo<String> REPLICATIONTYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ReplicationType").build();
    private static final MarshallingInfo<String> STATUS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Status").build();
    private static final MarshallingInfo<StructuredPojo> PROVISIONDATA_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ProvisionData").build();
    private static final MarshallingInfo<String> STOPREASON_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("StopReason").build();
    private static final MarshallingInfo<List> FAILUREMESSAGES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("FailureMessages").build();
    private static final MarshallingInfo<StructuredPojo> REPLICATIONSTATS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ReplicationStats").build();
    private static final MarshallingInfo<String> STARTREPLICATIONTYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("StartReplicationType").build();
    private static final MarshallingInfo<Date> CDCSTARTTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CdcStartTime").timestampFormat("unixTimestamp").build();
    private static final MarshallingInfo<String> CDCSTARTPOSITION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CdcStartPosition").build();
    private static final MarshallingInfo<String> CDCSTOPPOSITION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CdcStopPosition").build();
    private static final MarshallingInfo<String> RECOVERYCHECKPOINT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RecoveryCheckpoint").build();
    private static final MarshallingInfo<Date> REPLICATIONCREATETIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ReplicationCreateTime").timestampFormat("unixTimestamp").build();
    private static final MarshallingInfo<Date> REPLICATIONUPDATETIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ReplicationUpdateTime").timestampFormat("unixTimestamp").build();
    private static final MarshallingInfo<Date> REPLICATIONLASTSTOPTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ReplicationLastStopTime").timestampFormat("unixTimestamp").build();
    private static final MarshallingInfo<Date> REPLICATIONDEPROVISIONTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ReplicationDeprovisionTime").timestampFormat("unixTimestamp").build();
    private static final ReplicationMarshaller instance = new ReplicationMarshaller();

    public static ReplicationMarshaller getInstance() {
        return instance;
    }

    public void marshall(Replication replication, ProtocolMarshaller protocolMarshaller) {
        if (replication == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)replication.getReplicationConfigIdentifier(), REPLICATIONCONFIGIDENTIFIER_BINDING);
            protocolMarshaller.marshall((Object)replication.getReplicationConfigArn(), REPLICATIONCONFIGARN_BINDING);
            protocolMarshaller.marshall((Object)replication.getSourceEndpointArn(), SOURCEENDPOINTARN_BINDING);
            protocolMarshaller.marshall((Object)replication.getTargetEndpointArn(), TARGETENDPOINTARN_BINDING);
            protocolMarshaller.marshall((Object)replication.getReplicationType(), REPLICATIONTYPE_BINDING);
            protocolMarshaller.marshall((Object)replication.getStatus(), STATUS_BINDING);
            protocolMarshaller.marshall((Object)replication.getProvisionData(), PROVISIONDATA_BINDING);
            protocolMarshaller.marshall((Object)replication.getStopReason(), STOPREASON_BINDING);
            protocolMarshaller.marshall(replication.getFailureMessages(), FAILUREMESSAGES_BINDING);
            protocolMarshaller.marshall((Object)replication.getReplicationStats(), REPLICATIONSTATS_BINDING);
            protocolMarshaller.marshall((Object)replication.getStartReplicationType(), STARTREPLICATIONTYPE_BINDING);
            protocolMarshaller.marshall((Object)replication.getCdcStartTime(), CDCSTARTTIME_BINDING);
            protocolMarshaller.marshall((Object)replication.getCdcStartPosition(), CDCSTARTPOSITION_BINDING);
            protocolMarshaller.marshall((Object)replication.getCdcStopPosition(), CDCSTOPPOSITION_BINDING);
            protocolMarshaller.marshall((Object)replication.getRecoveryCheckpoint(), RECOVERYCHECKPOINT_BINDING);
            protocolMarshaller.marshall((Object)replication.getReplicationCreateTime(), REPLICATIONCREATETIME_BINDING);
            protocolMarshaller.marshall((Object)replication.getReplicationUpdateTime(), REPLICATIONUPDATETIME_BINDING);
            protocolMarshaller.marshall((Object)replication.getReplicationLastStopTime(), REPLICATIONLASTSTOPTIME_BINDING);
            protocolMarshaller.marshall((Object)replication.getReplicationDeprovisionTime(), REPLICATIONDEPROVISIONTIME_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

