/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dlm.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.dlm.model.ArchiveRule;
import com.amazonaws.services.dlm.model.CreateRule;
import com.amazonaws.services.dlm.model.CrossRegionCopyRule;
import com.amazonaws.services.dlm.model.DeprecateRule;
import com.amazonaws.services.dlm.model.FastRestoreRule;
import com.amazonaws.services.dlm.model.RetainRule;
import com.amazonaws.services.dlm.model.ShareRule;
import com.amazonaws.services.dlm.model.Tag;
import com.amazonaws.services.dlm.model.transform.ScheduleMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class Schedule
implements Serializable,
Cloneable,
StructuredPojo {
    private String name;
    private Boolean copyTags;
    private List<Tag> tagsToAdd;
    private List<Tag> variableTags;
    private CreateRule createRule;
    private RetainRule retainRule;
    private FastRestoreRule fastRestoreRule;
    private List<CrossRegionCopyRule> crossRegionCopyRules;
    private List<ShareRule> shareRules;
    private DeprecateRule deprecateRule;
    private ArchiveRule archiveRule;

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public Schedule withName(String name) {
        this.setName(name);
        return this;
    }

    public void setCopyTags(Boolean copyTags) {
        this.copyTags = copyTags;
    }

    public Boolean getCopyTags() {
        return this.copyTags;
    }

    public Schedule withCopyTags(Boolean copyTags) {
        this.setCopyTags(copyTags);
        return this;
    }

    public Boolean isCopyTags() {
        return this.copyTags;
    }

    public List<Tag> getTagsToAdd() {
        return this.tagsToAdd;
    }

    public void setTagsToAdd(Collection<Tag> tagsToAdd) {
        if (tagsToAdd == null) {
            this.tagsToAdd = null;
            return;
        }
        this.tagsToAdd = new ArrayList<Tag>(tagsToAdd);
    }

    public Schedule withTagsToAdd(Tag ... tagsToAdd) {
        if (this.tagsToAdd == null) {
            this.setTagsToAdd(new ArrayList<Tag>(tagsToAdd.length));
        }
        for (Tag ele : tagsToAdd) {
            this.tagsToAdd.add(ele);
        }
        return this;
    }

    public Schedule withTagsToAdd(Collection<Tag> tagsToAdd) {
        this.setTagsToAdd(tagsToAdd);
        return this;
    }

    public List<Tag> getVariableTags() {
        return this.variableTags;
    }

    public void setVariableTags(Collection<Tag> variableTags) {
        if (variableTags == null) {
            this.variableTags = null;
            return;
        }
        this.variableTags = new ArrayList<Tag>(variableTags);
    }

    public Schedule withVariableTags(Tag ... variableTags) {
        if (this.variableTags == null) {
            this.setVariableTags(new ArrayList<Tag>(variableTags.length));
        }
        for (Tag ele : variableTags) {
            this.variableTags.add(ele);
        }
        return this;
    }

    public Schedule withVariableTags(Collection<Tag> variableTags) {
        this.setVariableTags(variableTags);
        return this;
    }

    public void setCreateRule(CreateRule createRule) {
        this.createRule = createRule;
    }

    public CreateRule getCreateRule() {
        return this.createRule;
    }

    public Schedule withCreateRule(CreateRule createRule) {
        this.setCreateRule(createRule);
        return this;
    }

    public void setRetainRule(RetainRule retainRule) {
        this.retainRule = retainRule;
    }

    public RetainRule getRetainRule() {
        return this.retainRule;
    }

    public Schedule withRetainRule(RetainRule retainRule) {
        this.setRetainRule(retainRule);
        return this;
    }

    public void setFastRestoreRule(FastRestoreRule fastRestoreRule) {
        this.fastRestoreRule = fastRestoreRule;
    }

    public FastRestoreRule getFastRestoreRule() {
        return this.fastRestoreRule;
    }

    public Schedule withFastRestoreRule(FastRestoreRule fastRestoreRule) {
        this.setFastRestoreRule(fastRestoreRule);
        return this;
    }

    public List<CrossRegionCopyRule> getCrossRegionCopyRules() {
        return this.crossRegionCopyRules;
    }

    public void setCrossRegionCopyRules(Collection<CrossRegionCopyRule> crossRegionCopyRules) {
        if (crossRegionCopyRules == null) {
            this.crossRegionCopyRules = null;
            return;
        }
        this.crossRegionCopyRules = new ArrayList<CrossRegionCopyRule>(crossRegionCopyRules);
    }

    public Schedule withCrossRegionCopyRules(CrossRegionCopyRule ... crossRegionCopyRules) {
        if (this.crossRegionCopyRules == null) {
            this.setCrossRegionCopyRules(new ArrayList<CrossRegionCopyRule>(crossRegionCopyRules.length));
        }
        for (CrossRegionCopyRule ele : crossRegionCopyRules) {
            this.crossRegionCopyRules.add(ele);
        }
        return this;
    }

    public Schedule withCrossRegionCopyRules(Collection<CrossRegionCopyRule> crossRegionCopyRules) {
        this.setCrossRegionCopyRules(crossRegionCopyRules);
        return this;
    }

    public List<ShareRule> getShareRules() {
        return this.shareRules;
    }

    public void setShareRules(Collection<ShareRule> shareRules) {
        if (shareRules == null) {
            this.shareRules = null;
            return;
        }
        this.shareRules = new ArrayList<ShareRule>(shareRules);
    }

    public Schedule withShareRules(ShareRule ... shareRules) {
        if (this.shareRules == null) {
            this.setShareRules(new ArrayList<ShareRule>(shareRules.length));
        }
        for (ShareRule ele : shareRules) {
            this.shareRules.add(ele);
        }
        return this;
    }

    public Schedule withShareRules(Collection<ShareRule> shareRules) {
        this.setShareRules(shareRules);
        return this;
    }

    public void setDeprecateRule(DeprecateRule deprecateRule) {
        this.deprecateRule = deprecateRule;
    }

    public DeprecateRule getDeprecateRule() {
        return this.deprecateRule;
    }

    public Schedule withDeprecateRule(DeprecateRule deprecateRule) {
        this.setDeprecateRule(deprecateRule);
        return this;
    }

    public void setArchiveRule(ArchiveRule archiveRule) {
        this.archiveRule = archiveRule;
    }

    public ArchiveRule getArchiveRule() {
        return this.archiveRule;
    }

    public Schedule withArchiveRule(ArchiveRule archiveRule) {
        this.setArchiveRule(archiveRule);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getName() != null) {
            sb.append("Name: ").append(this.getName()).append(",");
        }
        if (this.getCopyTags() != null) {
            sb.append("CopyTags: ").append(this.getCopyTags()).append(",");
        }
        if (this.getTagsToAdd() != null) {
            sb.append("TagsToAdd: ").append(this.getTagsToAdd()).append(",");
        }
        if (this.getVariableTags() != null) {
            sb.append("VariableTags: ").append(this.getVariableTags()).append(",");
        }
        if (this.getCreateRule() != null) {
            sb.append("CreateRule: ").append(this.getCreateRule()).append(",");
        }
        if (this.getRetainRule() != null) {
            sb.append("RetainRule: ").append(this.getRetainRule()).append(",");
        }
        if (this.getFastRestoreRule() != null) {
            sb.append("FastRestoreRule: ").append(this.getFastRestoreRule()).append(",");
        }
        if (this.getCrossRegionCopyRules() != null) {
            sb.append("CrossRegionCopyRules: ").append(this.getCrossRegionCopyRules()).append(",");
        }
        if (this.getShareRules() != null) {
            sb.append("ShareRules: ").append(this.getShareRules()).append(",");
        }
        if (this.getDeprecateRule() != null) {
            sb.append("DeprecateRule: ").append(this.getDeprecateRule()).append(",");
        }
        if (this.getArchiveRule() != null) {
            sb.append("ArchiveRule: ").append(this.getArchiveRule());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Schedule)) {
            return false;
        }
        Schedule other = (Schedule)obj;
        if (other.getName() == null ^ this.getName() == null) {
            return false;
        }
        if (other.getName() != null && !other.getName().equals(this.getName())) {
            return false;
        }
        if (other.getCopyTags() == null ^ this.getCopyTags() == null) {
            return false;
        }
        if (other.getCopyTags() != null && !other.getCopyTags().equals(this.getCopyTags())) {
            return false;
        }
        if (other.getTagsToAdd() == null ^ this.getTagsToAdd() == null) {
            return false;
        }
        if (other.getTagsToAdd() != null && !other.getTagsToAdd().equals(this.getTagsToAdd())) {
            return false;
        }
        if (other.getVariableTags() == null ^ this.getVariableTags() == null) {
            return false;
        }
        if (other.getVariableTags() != null && !other.getVariableTags().equals(this.getVariableTags())) {
            return false;
        }
        if (other.getCreateRule() == null ^ this.getCreateRule() == null) {
            return false;
        }
        if (other.getCreateRule() != null && !other.getCreateRule().equals(this.getCreateRule())) {
            return false;
        }
        if (other.getRetainRule() == null ^ this.getRetainRule() == null) {
            return false;
        }
        if (other.getRetainRule() != null && !other.getRetainRule().equals(this.getRetainRule())) {
            return false;
        }
        if (other.getFastRestoreRule() == null ^ this.getFastRestoreRule() == null) {
            return false;
        }
        if (other.getFastRestoreRule() != null && !other.getFastRestoreRule().equals(this.getFastRestoreRule())) {
            return false;
        }
        if (other.getCrossRegionCopyRules() == null ^ this.getCrossRegionCopyRules() == null) {
            return false;
        }
        if (other.getCrossRegionCopyRules() != null && !other.getCrossRegionCopyRules().equals(this.getCrossRegionCopyRules())) {
            return false;
        }
        if (other.getShareRules() == null ^ this.getShareRules() == null) {
            return false;
        }
        if (other.getShareRules() != null && !other.getShareRules().equals(this.getShareRules())) {
            return false;
        }
        if (other.getDeprecateRule() == null ^ this.getDeprecateRule() == null) {
            return false;
        }
        if (other.getDeprecateRule() != null && !other.getDeprecateRule().equals(this.getDeprecateRule())) {
            return false;
        }
        if (other.getArchiveRule() == null ^ this.getArchiveRule() == null) {
            return false;
        }
        return other.getArchiveRule() == null || other.getArchiveRule().equals(this.getArchiveRule());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getName() == null ? 0 : this.getName().hashCode());
        hashCode = 31 * hashCode + (this.getCopyTags() == null ? 0 : this.getCopyTags().hashCode());
        hashCode = 31 * hashCode + (this.getTagsToAdd() == null ? 0 : this.getTagsToAdd().hashCode());
        hashCode = 31 * hashCode + (this.getVariableTags() == null ? 0 : this.getVariableTags().hashCode());
        hashCode = 31 * hashCode + (this.getCreateRule() == null ? 0 : this.getCreateRule().hashCode());
        hashCode = 31 * hashCode + (this.getRetainRule() == null ? 0 : this.getRetainRule().hashCode());
        hashCode = 31 * hashCode + (this.getFastRestoreRule() == null ? 0 : this.getFastRestoreRule().hashCode());
        hashCode = 31 * hashCode + (this.getCrossRegionCopyRules() == null ? 0 : this.getCrossRegionCopyRules().hashCode());
        hashCode = 31 * hashCode + (this.getShareRules() == null ? 0 : this.getShareRules().hashCode());
        hashCode = 31 * hashCode + (this.getDeprecateRule() == null ? 0 : this.getDeprecateRule().hashCode());
        hashCode = 31 * hashCode + (this.getArchiveRule() == null ? 0 : this.getArchiveRule().hashCode());
        return hashCode;
    }

    public Schedule clone() {
        try {
            return (Schedule)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ScheduleMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

