/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.devopsguru.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.services.devopsguru.model.NotificationChannel;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ListNotificationChannelsResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private List<NotificationChannel> channels;
    private String nextToken;

    public List<NotificationChannel> getChannels() {
        return this.channels;
    }

    public void setChannels(Collection<NotificationChannel> channels) {
        if (channels == null) {
            this.channels = null;
            return;
        }
        this.channels = new ArrayList<NotificationChannel>(channels);
    }

    public ListNotificationChannelsResult withChannels(NotificationChannel ... channels) {
        if (this.channels == null) {
            this.setChannels(new ArrayList<NotificationChannel>(channels.length));
        }
        for (NotificationChannel ele : channels) {
            this.channels.add(ele);
        }
        return this;
    }

    public ListNotificationChannelsResult withChannels(Collection<NotificationChannel> channels) {
        this.setChannels(channels);
        return this;
    }

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public ListNotificationChannelsResult withNextToken(String nextToken) {
        this.setNextToken(nextToken);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getChannels() != null) {
            sb.append("Channels: ").append(this.getChannels()).append(",");
        }
        if (this.getNextToken() != null) {
            sb.append("NextToken: ").append(this.getNextToken());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListNotificationChannelsResult)) {
            return false;
        }
        ListNotificationChannelsResult other = (ListNotificationChannelsResult)obj;
        if (other.getChannels() == null ^ this.getChannels() == null) {
            return false;
        }
        if (other.getChannels() != null && !other.getChannels().equals(this.getChannels())) {
            return false;
        }
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        return other.getNextToken() == null || other.getNextToken().equals(this.getNextToken());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getChannels() == null ? 0 : this.getChannels().hashCode());
        hashCode = 31 * hashCode + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        return hashCode;
    }

    public ListNotificationChannelsResult clone() {
        try {
            return (ListNotificationChannelsResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

