/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.devicefarm.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.devicefarm.model.CPU;
import com.amazonaws.services.devicefarm.model.DeviceAvailability;
import com.amazonaws.services.devicefarm.model.DeviceFormFactor;
import com.amazonaws.services.devicefarm.model.DeviceInstance;
import com.amazonaws.services.devicefarm.model.DevicePlatform;
import com.amazonaws.services.devicefarm.model.Resolution;
import com.amazonaws.services.devicefarm.model.transform.DeviceMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class Device
implements Serializable,
Cloneable,
StructuredPojo {
    private String arn;
    private String name;
    private String manufacturer;
    private String model;
    private String modelId;
    private String formFactor;
    private String platform;
    private String os;
    private CPU cpu;
    private Resolution resolution;
    private Long heapSize;
    private Long memory;
    private String image;
    private String carrier;
    private String radio;
    private Boolean remoteAccessEnabled;
    private Boolean remoteDebugEnabled;
    private String fleetType;
    private String fleetName;
    private List<DeviceInstance> instances;
    private String availability;

    public void setArn(String arn) {
        this.arn = arn;
    }

    public String getArn() {
        return this.arn;
    }

    public Device withArn(String arn) {
        this.setArn(arn);
        return this;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public Device withName(String name) {
        this.setName(name);
        return this;
    }

    public void setManufacturer(String manufacturer) {
        this.manufacturer = manufacturer;
    }

    public String getManufacturer() {
        return this.manufacturer;
    }

    public Device withManufacturer(String manufacturer) {
        this.setManufacturer(manufacturer);
        return this;
    }

    public void setModel(String model) {
        this.model = model;
    }

    public String getModel() {
        return this.model;
    }

    public Device withModel(String model) {
        this.setModel(model);
        return this;
    }

    public void setModelId(String modelId) {
        this.modelId = modelId;
    }

    public String getModelId() {
        return this.modelId;
    }

    public Device withModelId(String modelId) {
        this.setModelId(modelId);
        return this;
    }

    public void setFormFactor(String formFactor) {
        this.formFactor = formFactor;
    }

    public String getFormFactor() {
        return this.formFactor;
    }

    public Device withFormFactor(String formFactor) {
        this.setFormFactor(formFactor);
        return this;
    }

    public void setFormFactor(DeviceFormFactor formFactor) {
        this.withFormFactor(formFactor);
    }

    public Device withFormFactor(DeviceFormFactor formFactor) {
        this.formFactor = formFactor.toString();
        return this;
    }

    public void setPlatform(String platform) {
        this.platform = platform;
    }

    public String getPlatform() {
        return this.platform;
    }

    public Device withPlatform(String platform) {
        this.setPlatform(platform);
        return this;
    }

    public void setPlatform(DevicePlatform platform) {
        this.withPlatform(platform);
    }

    public Device withPlatform(DevicePlatform platform) {
        this.platform = platform.toString();
        return this;
    }

    public void setOs(String os) {
        this.os = os;
    }

    public String getOs() {
        return this.os;
    }

    public Device withOs(String os) {
        this.setOs(os);
        return this;
    }

    public void setCpu(CPU cpu) {
        this.cpu = cpu;
    }

    public CPU getCpu() {
        return this.cpu;
    }

    public Device withCpu(CPU cpu) {
        this.setCpu(cpu);
        return this;
    }

    public void setResolution(Resolution resolution) {
        this.resolution = resolution;
    }

    public Resolution getResolution() {
        return this.resolution;
    }

    public Device withResolution(Resolution resolution) {
        this.setResolution(resolution);
        return this;
    }

    public void setHeapSize(Long heapSize) {
        this.heapSize = heapSize;
    }

    public Long getHeapSize() {
        return this.heapSize;
    }

    public Device withHeapSize(Long heapSize) {
        this.setHeapSize(heapSize);
        return this;
    }

    public void setMemory(Long memory) {
        this.memory = memory;
    }

    public Long getMemory() {
        return this.memory;
    }

    public Device withMemory(Long memory) {
        this.setMemory(memory);
        return this;
    }

    public void setImage(String image) {
        this.image = image;
    }

    public String getImage() {
        return this.image;
    }

    public Device withImage(String image) {
        this.setImage(image);
        return this;
    }

    public void setCarrier(String carrier) {
        this.carrier = carrier;
    }

    public String getCarrier() {
        return this.carrier;
    }

    public Device withCarrier(String carrier) {
        this.setCarrier(carrier);
        return this;
    }

    public void setRadio(String radio) {
        this.radio = radio;
    }

    public String getRadio() {
        return this.radio;
    }

    public Device withRadio(String radio) {
        this.setRadio(radio);
        return this;
    }

    public void setRemoteAccessEnabled(Boolean remoteAccessEnabled) {
        this.remoteAccessEnabled = remoteAccessEnabled;
    }

    public Boolean getRemoteAccessEnabled() {
        return this.remoteAccessEnabled;
    }

    public Device withRemoteAccessEnabled(Boolean remoteAccessEnabled) {
        this.setRemoteAccessEnabled(remoteAccessEnabled);
        return this;
    }

    public Boolean isRemoteAccessEnabled() {
        return this.remoteAccessEnabled;
    }

    public void setRemoteDebugEnabled(Boolean remoteDebugEnabled) {
        this.remoteDebugEnabled = remoteDebugEnabled;
    }

    public Boolean getRemoteDebugEnabled() {
        return this.remoteDebugEnabled;
    }

    public Device withRemoteDebugEnabled(Boolean remoteDebugEnabled) {
        this.setRemoteDebugEnabled(remoteDebugEnabled);
        return this;
    }

    public Boolean isRemoteDebugEnabled() {
        return this.remoteDebugEnabled;
    }

    public void setFleetType(String fleetType) {
        this.fleetType = fleetType;
    }

    public String getFleetType() {
        return this.fleetType;
    }

    public Device withFleetType(String fleetType) {
        this.setFleetType(fleetType);
        return this;
    }

    public void setFleetName(String fleetName) {
        this.fleetName = fleetName;
    }

    public String getFleetName() {
        return this.fleetName;
    }

    public Device withFleetName(String fleetName) {
        this.setFleetName(fleetName);
        return this;
    }

    public List<DeviceInstance> getInstances() {
        return this.instances;
    }

    public void setInstances(Collection<DeviceInstance> instances) {
        if (instances == null) {
            this.instances = null;
            return;
        }
        this.instances = new ArrayList<DeviceInstance>(instances);
    }

    public Device withInstances(DeviceInstance ... instances) {
        if (this.instances == null) {
            this.setInstances(new ArrayList<DeviceInstance>(instances.length));
        }
        for (DeviceInstance ele : instances) {
            this.instances.add(ele);
        }
        return this;
    }

    public Device withInstances(Collection<DeviceInstance> instances) {
        this.setInstances(instances);
        return this;
    }

    public void setAvailability(String availability) {
        this.availability = availability;
    }

    public String getAvailability() {
        return this.availability;
    }

    public Device withAvailability(String availability) {
        this.setAvailability(availability);
        return this;
    }

    public void setAvailability(DeviceAvailability availability) {
        this.withAvailability(availability);
    }

    public Device withAvailability(DeviceAvailability availability) {
        this.availability = availability.toString();
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getArn() != null) {
            sb.append("Arn: ").append(this.getArn()).append(",");
        }
        if (this.getName() != null) {
            sb.append("Name: ").append(this.getName()).append(",");
        }
        if (this.getManufacturer() != null) {
            sb.append("Manufacturer: ").append(this.getManufacturer()).append(",");
        }
        if (this.getModel() != null) {
            sb.append("Model: ").append(this.getModel()).append(",");
        }
        if (this.getModelId() != null) {
            sb.append("ModelId: ").append(this.getModelId()).append(",");
        }
        if (this.getFormFactor() != null) {
            sb.append("FormFactor: ").append(this.getFormFactor()).append(",");
        }
        if (this.getPlatform() != null) {
            sb.append("Platform: ").append(this.getPlatform()).append(",");
        }
        if (this.getOs() != null) {
            sb.append("Os: ").append(this.getOs()).append(",");
        }
        if (this.getCpu() != null) {
            sb.append("Cpu: ").append(this.getCpu()).append(",");
        }
        if (this.getResolution() != null) {
            sb.append("Resolution: ").append(this.getResolution()).append(",");
        }
        if (this.getHeapSize() != null) {
            sb.append("HeapSize: ").append(this.getHeapSize()).append(",");
        }
        if (this.getMemory() != null) {
            sb.append("Memory: ").append(this.getMemory()).append(",");
        }
        if (this.getImage() != null) {
            sb.append("Image: ").append(this.getImage()).append(",");
        }
        if (this.getCarrier() != null) {
            sb.append("Carrier: ").append(this.getCarrier()).append(",");
        }
        if (this.getRadio() != null) {
            sb.append("Radio: ").append(this.getRadio()).append(",");
        }
        if (this.getRemoteAccessEnabled() != null) {
            sb.append("RemoteAccessEnabled: ").append(this.getRemoteAccessEnabled()).append(",");
        }
        if (this.getRemoteDebugEnabled() != null) {
            sb.append("RemoteDebugEnabled: ").append(this.getRemoteDebugEnabled()).append(",");
        }
        if (this.getFleetType() != null) {
            sb.append("FleetType: ").append(this.getFleetType()).append(",");
        }
        if (this.getFleetName() != null) {
            sb.append("FleetName: ").append(this.getFleetName()).append(",");
        }
        if (this.getInstances() != null) {
            sb.append("Instances: ").append(this.getInstances()).append(",");
        }
        if (this.getAvailability() != null) {
            sb.append("Availability: ").append(this.getAvailability());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Device)) {
            return false;
        }
        Device other = (Device)obj;
        if (other.getArn() == null ^ this.getArn() == null) {
            return false;
        }
        if (other.getArn() != null && !other.getArn().equals(this.getArn())) {
            return false;
        }
        if (other.getName() == null ^ this.getName() == null) {
            return false;
        }
        if (other.getName() != null && !other.getName().equals(this.getName())) {
            return false;
        }
        if (other.getManufacturer() == null ^ this.getManufacturer() == null) {
            return false;
        }
        if (other.getManufacturer() != null && !other.getManufacturer().equals(this.getManufacturer())) {
            return false;
        }
        if (other.getModel() == null ^ this.getModel() == null) {
            return false;
        }
        if (other.getModel() != null && !other.getModel().equals(this.getModel())) {
            return false;
        }
        if (other.getModelId() == null ^ this.getModelId() == null) {
            return false;
        }
        if (other.getModelId() != null && !other.getModelId().equals(this.getModelId())) {
            return false;
        }
        if (other.getFormFactor() == null ^ this.getFormFactor() == null) {
            return false;
        }
        if (other.getFormFactor() != null && !other.getFormFactor().equals(this.getFormFactor())) {
            return false;
        }
        if (other.getPlatform() == null ^ this.getPlatform() == null) {
            return false;
        }
        if (other.getPlatform() != null && !other.getPlatform().equals(this.getPlatform())) {
            return false;
        }
        if (other.getOs() == null ^ this.getOs() == null) {
            return false;
        }
        if (other.getOs() != null && !other.getOs().equals(this.getOs())) {
            return false;
        }
        if (other.getCpu() == null ^ this.getCpu() == null) {
            return false;
        }
        if (other.getCpu() != null && !other.getCpu().equals(this.getCpu())) {
            return false;
        }
        if (other.getResolution() == null ^ this.getResolution() == null) {
            return false;
        }
        if (other.getResolution() != null && !other.getResolution().equals(this.getResolution())) {
            return false;
        }
        if (other.getHeapSize() == null ^ this.getHeapSize() == null) {
            return false;
        }
        if (other.getHeapSize() != null && !other.getHeapSize().equals(this.getHeapSize())) {
            return false;
        }
        if (other.getMemory() == null ^ this.getMemory() == null) {
            return false;
        }
        if (other.getMemory() != null && !other.getMemory().equals(this.getMemory())) {
            return false;
        }
        if (other.getImage() == null ^ this.getImage() == null) {
            return false;
        }
        if (other.getImage() != null && !other.getImage().equals(this.getImage())) {
            return false;
        }
        if (other.getCarrier() == null ^ this.getCarrier() == null) {
            return false;
        }
        if (other.getCarrier() != null && !other.getCarrier().equals(this.getCarrier())) {
            return false;
        }
        if (other.getRadio() == null ^ this.getRadio() == null) {
            return false;
        }
        if (other.getRadio() != null && !other.getRadio().equals(this.getRadio())) {
            return false;
        }
        if (other.getRemoteAccessEnabled() == null ^ this.getRemoteAccessEnabled() == null) {
            return false;
        }
        if (other.getRemoteAccessEnabled() != null && !other.getRemoteAccessEnabled().equals(this.getRemoteAccessEnabled())) {
            return false;
        }
        if (other.getRemoteDebugEnabled() == null ^ this.getRemoteDebugEnabled() == null) {
            return false;
        }
        if (other.getRemoteDebugEnabled() != null && !other.getRemoteDebugEnabled().equals(this.getRemoteDebugEnabled())) {
            return false;
        }
        if (other.getFleetType() == null ^ this.getFleetType() == null) {
            return false;
        }
        if (other.getFleetType() != null && !other.getFleetType().equals(this.getFleetType())) {
            return false;
        }
        if (other.getFleetName() == null ^ this.getFleetName() == null) {
            return false;
        }
        if (other.getFleetName() != null && !other.getFleetName().equals(this.getFleetName())) {
            return false;
        }
        if (other.getInstances() == null ^ this.getInstances() == null) {
            return false;
        }
        if (other.getInstances() != null && !other.getInstances().equals(this.getInstances())) {
            return false;
        }
        if (other.getAvailability() == null ^ this.getAvailability() == null) {
            return false;
        }
        return other.getAvailability() == null || other.getAvailability().equals(this.getAvailability());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getArn() == null ? 0 : this.getArn().hashCode());
        hashCode = 31 * hashCode + (this.getName() == null ? 0 : this.getName().hashCode());
        hashCode = 31 * hashCode + (this.getManufacturer() == null ? 0 : this.getManufacturer().hashCode());
        hashCode = 31 * hashCode + (this.getModel() == null ? 0 : this.getModel().hashCode());
        hashCode = 31 * hashCode + (this.getModelId() == null ? 0 : this.getModelId().hashCode());
        hashCode = 31 * hashCode + (this.getFormFactor() == null ? 0 : this.getFormFactor().hashCode());
        hashCode = 31 * hashCode + (this.getPlatform() == null ? 0 : this.getPlatform().hashCode());
        hashCode = 31 * hashCode + (this.getOs() == null ? 0 : this.getOs().hashCode());
        hashCode = 31 * hashCode + (this.getCpu() == null ? 0 : this.getCpu().hashCode());
        hashCode = 31 * hashCode + (this.getResolution() == null ? 0 : this.getResolution().hashCode());
        hashCode = 31 * hashCode + (this.getHeapSize() == null ? 0 : this.getHeapSize().hashCode());
        hashCode = 31 * hashCode + (this.getMemory() == null ? 0 : this.getMemory().hashCode());
        hashCode = 31 * hashCode + (this.getImage() == null ? 0 : this.getImage().hashCode());
        hashCode = 31 * hashCode + (this.getCarrier() == null ? 0 : this.getCarrier().hashCode());
        hashCode = 31 * hashCode + (this.getRadio() == null ? 0 : this.getRadio().hashCode());
        hashCode = 31 * hashCode + (this.getRemoteAccessEnabled() == null ? 0 : this.getRemoteAccessEnabled().hashCode());
        hashCode = 31 * hashCode + (this.getRemoteDebugEnabled() == null ? 0 : this.getRemoteDebugEnabled().hashCode());
        hashCode = 31 * hashCode + (this.getFleetType() == null ? 0 : this.getFleetType().hashCode());
        hashCode = 31 * hashCode + (this.getFleetName() == null ? 0 : this.getFleetName().hashCode());
        hashCode = 31 * hashCode + (this.getInstances() == null ? 0 : this.getInstances().hashCode());
        hashCode = 31 * hashCode + (this.getAvailability() == null ? 0 : this.getAvailability().hashCode());
        return hashCode;
    }

    public Device clone() {
        try {
            return (Device)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        DeviceMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

