/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.devicefarm.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.services.devicefarm.model.Device;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ListDevicesResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private List<Device> devices;
    private String nextToken;

    public List<Device> getDevices() {
        return this.devices;
    }

    public void setDevices(Collection<Device> devices) {
        if (devices == null) {
            this.devices = null;
            return;
        }
        this.devices = new ArrayList<Device>(devices);
    }

    public ListDevicesResult withDevices(Device ... devices) {
        if (this.devices == null) {
            this.setDevices(new ArrayList<Device>(devices.length));
        }
        for (Device ele : devices) {
            this.devices.add(ele);
        }
        return this;
    }

    public ListDevicesResult withDevices(Collection<Device> devices) {
        this.setDevices(devices);
        return this;
    }

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public ListDevicesResult withNextToken(String nextToken) {
        this.setNextToken(nextToken);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getDevices() != null) {
            sb.append("Devices: " + this.getDevices() + ",");
        }
        if (this.getNextToken() != null) {
            sb.append("NextToken: " + this.getNextToken());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListDevicesResult)) {
            return false;
        }
        ListDevicesResult other = (ListDevicesResult)obj;
        if (other.getDevices() == null ^ this.getDevices() == null) {
            return false;
        }
        if (other.getDevices() != null && !other.getDevices().equals(this.getDevices())) {
            return false;
        }
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        return other.getNextToken() == null || other.getNextToken().equals(this.getNextToken());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getDevices() == null ? 0 : this.getDevices().hashCode());
        hashCode = 31 * hashCode + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        return hashCode;
    }

    public ListDevicesResult clone() {
        try {
            return (ListDevicesResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

